/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;

public class SequenceToCollection
extends AbstractTransformer {
    private static final long serialVersionUID = 1363005679574784724L;
    public static final String BACKUP_ELEMENTS = "elements";
    protected List m_Elements;
    protected int m_CollectionSize;
    protected String m_CollectionClass;

    @Override
    public String globalInfo() {
        return "Turns a sequence of tokens into a collection.\nIn case of unspecified length (ie -1), a collection containing all elements collected so far is output each time a token arrives, i.e., the internal buffer never gets reset.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("size", "collectionSize", 1, -1, null);
        this.m_OptionManager.add("collection-class", "collectionClass", ArrayList.class.getName());
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "collectionSize", this.m_CollectionSize, "Size: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "collectionClass", this.m_CollectionClass.length() != 0 ? this.m_CollectionClass : "-none-", ", Class: ");
        return result;
    }

    public void setCollectionSize(int value) {
        if (value > 0 || value == -1) {
            this.m_CollectionSize = value;
            this.reset();
        } else {
            this.getLogger().severe("Collection(s) must have a size of at least 1 (or -1 for unspecified size), provided: " + value + "!");
        }
    }

    public int getCollectionSize() {
        return this.m_CollectionSize;
    }

    public String collectionSizeTipText() {
        return "The size of the collection(s).";
    }

    public void setCollectionClass(String value) {
        if (value.length() > 0) {
            this.m_CollectionClass = value;
            this.reset();
        } else {
            this.getLogger().severe("Class cannot be empty!");
        }
    }

    public String getCollectionClass() {
        return this.m_CollectionClass;
    }

    public String collectionClassTipText() {
        return "The class to use for the collection.";
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_ELEMENTS);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        result.put(BACKUP_ELEMENTS, this.m_Elements);
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_ELEMENTS)) {
            this.m_Elements = (List)state.get(BACKUP_ELEMENTS);
            state.remove(BACKUP_ELEMENTS);
        }
        super.restoreState(state);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Elements = new ArrayList();
        this.m_OutputToken = null;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public Class[] generates() {
        try {
            return new Class[]{Class.forName(this.m_CollectionClass)};
        }
        catch (Exception e) {
            return new Class[]{Collection.class};
        }
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            this.m_Elements.add(this.m_InputToken.getPayload());
            this.getLogger().info("Buffered elements: " + this.m_Elements.size());
            if (this.m_CollectionSize == -1 || this.m_Elements.size() == this.m_CollectionSize) {
                Collection coll = (Collection)Class.forName(this.m_CollectionClass).newInstance();
                this.getLogger().info("Collection type: " + coll.getClass().getComponentType());
                coll.addAll(this.m_Elements);
                this.m_OutputToken = new Token(coll);
                if (this.m_CollectionSize > -1) {
                    this.m_Elements.clear();
                }
                this.getLogger().info("Collection generated");
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to turn sequence into collection: ", e);
        }
        return result;
    }
}

