/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.application;

import adams.core.base.BaseString;
import adams.core.io.PlaceholderDirectory;
import adams.core.logging.ConsolePanelHandler;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingLevel;
import adams.core.management.Launcher;
import adams.core.management.ProcessUtils;
import adams.core.management.RestartableApplication;
import adams.core.net.InternetHelper;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionUtils;
import adams.db.AbstractDatabaseConnection;
import adams.db.AbstractIndexedTable;
import adams.db.DatabaseConnectionHandler;
import adams.env.Environment;
import adams.event.DatabaseConnectionChangeEvent;
import adams.event.DatabaseConnectionChangeListener;
import adams.gui.application.AbstractInitialization;
import adams.gui.application.AbstractMenuItemDefinition;
import adams.gui.application.AdditionalParameterHandler;
import adams.gui.application.ApplicationMenu;
import adams.gui.application.Child;
import adams.gui.application.ChildFrame;
import adams.gui.application.ChildWindow;
import adams.gui.application.UserMode;
import adams.gui.core.AbstractFrameWithOptionHandling;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.scripting.ScriptingEngine;
import adams.gui.scripting.ScriptingEngineHandler;
import adams.gui.scripting.ScriptingLogPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public abstract class AbstractApplicationFrame
extends AbstractFrameWithOptionHandling
implements DatabaseConnectionHandler,
DatabaseConnectionChangeListener,
RestartableApplication {
    private static final long serialVersionUID = -5800519559483605870L;
    public static final String LAYOUT_MENUBAR = "MenuBar";
    public static final String LAYOUT_MENU_PREFIX = "Menu.";
    public static final String LAYOUT_MENU_WINDOWS = "Windows";
    public static final String LAYOUT_SHORTCUT_SEPARATOR = "#";
    protected AbstractApplicationFrame m_Self;
    protected HashSet<Child> m_Children;
    protected JMenu m_MenuWindows;
    protected ScriptingLogPanel m_ScriptingLogPanel;
    protected AbstractDatabaseConnection m_DbConn;
    protected String m_ApplicationTitle;
    protected LoggingLevel m_LoggingLevel;
    protected UserMode m_UserMode;
    protected boolean m_EnableRestart;
    protected BaseString[] m_StartUps;
    protected PlaceholderDirectory[] m_DocumentationDirectories;
    protected ApplicationMenu m_AppMenu;
    protected boolean m_InitFinished;
    protected Logger m_Logger;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("logging-level", "loggingLevel", (Object)LoggingLevel.INFO);
        this.m_OptionManager.add("title", "applicationTitle", this.getDefaultApplicationTitle());
        this.m_OptionManager.add("user-mode", "userMode", UserMode.EXPERT);
        this.m_OptionManager.add("start-up", "startUps", new BaseString[0]);
        this.m_OptionManager.add("doc-dir", "documentationDirectories", new PlaceholderDirectory[0]);
        this.m_OptionManager.add("enable-restart", "enableRestart", false);
    }

    @Override
    protected void initialize() {
        this.m_InitFinished = false;
        super.initialize();
        this.initializeLogger();
        this.m_DbConn = this.getDefaultDatabaseConnection();
        this.m_DbConn.addChangeListener(this);
        this.m_ScriptingLogPanel = new ScriptingLogPanel();
        this.m_Children = new HashSet();
        this.m_AppMenu = null;
    }

    @Override
    protected void initializeLogger() {
        this.m_Logger = LoggingHelper.getLogger(this.getClass());
    }

    @Override
    public Logger getLogger() {
        return this.m_Logger;
    }

    protected abstract AbstractDatabaseConnection getDefaultDatabaseConnection();

    protected abstract String getDefaultApplicationTitle();

    public void setLoggingLevel(LoggingLevel value) {
        this.m_LoggingLevel = value;
        this.getDatabaseConnection().setLoggingLevel(value);
        this.getLogger().setLevel(value.getLevel());
    }

    public LoggingLevel getLoggingLevel() {
        return this.m_LoggingLevel;
    }

    public String loggingLevelTipText() {
        return "The logging level to use.";
    }

    public String getApplicationTitle() {
        return this.m_ApplicationTitle;
    }

    public void setApplicationTitle(String value) {
        this.m_ApplicationTitle = value;
        this.createTitle("");
    }

    public String applicationTitleTipText() {
        return "The title for the application.";
    }

    public void setUserMode(UserMode value) {
        if (this.m_UserMode != value) {
            this.m_UserMode = value;
            if (this.m_InitFinished) {
                this.setJMenuBar(this.createMenuBar());
                this.setVisible(true);
                this.windowListChanged();
            }
        }
    }

    public UserMode getUserMode() {
        return this.m_UserMode;
    }

    public String userModeTipText() {
        return "The user mode, which determines the visibility of the menu items.";
    }

    public BaseString[] getStartUps() {
        return this.m_StartUps;
    }

    public void setStartUps(BaseString[] value) {
        this.m_StartUps = value;
    }

    public String startUpsTipText() {
        return "The menu items to start up immediately; each consists of classname and optional parameters (in case the menu definition implements " + AdditionalParameterHandler.class.getName() + ").";
    }

    public PlaceholderDirectory[] getDocumentationDirectories() {
        return this.m_DocumentationDirectories;
    }

    public void setDocumentationDirectories(PlaceholderDirectory[] value) {
        this.m_DocumentationDirectories = value;
        if (this.m_InitFinished) {
            this.setJMenuBar(this.createMenuBar());
            this.setVisible(true);
            this.windowListChanged();
        }
    }

    public String documentationDirectoriesTipText() {
        return "The directories containing PDF documentation (may get listed in the Help menu).";
    }

    @Override
    public void setEnableRestart(boolean value) {
        if (value != this.m_EnableRestart) {
            this.m_EnableRestart = value;
            this.reset();
            this.setJMenuBar(this.createMenuBar());
        }
    }

    @Override
    public boolean getEnableRestart() {
        return this.m_EnableRestart;
    }

    @Override
    public String enableRestartTipText() {
        return "If enabled and started through the " + Launcher.class.getName() + " class, the application can be restarted through the menu.";
    }

    protected void setLookAndFeel() {
        GUIHelper.setLookAndFeel(GUIHelper.getLookAndFeel());
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_Self = this;
        this.setLookAndFeel();
        this.createTitle("");
        this.setDefaultCloseOperation(3);
        this.setJMenuBar(this.createMenuBar());
        this.pack();
        this.setSize(this.getGraphicsConfiguration().getBounds().width, this.getHeight());
        this.setLocation(0, 0);
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        AbstractInitialization.initAll(this);
        this.createTitle("");
        this.m_InitFinished = true;
        this.setUserMode(this.m_UserMode);
        LoggingHelper.setDefaultHandler(new ConsolePanelHandler());
    }

    protected void closeChildren() {
        Iterator<Child> iter = this.getWindowList();
        ArrayList<Child> list = new ArrayList<Child>();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        for (int i = 0; i < list.size(); ++i) {
            Child c = (Child)list.get(i);
            c.dispose();
        }
    }

    protected void closeApplication() {
        this.m_Self.dispose();
    }

    public void close() {
        this.closeChildren();
        this.closeApplication();
        System.exit(0);
    }

    protected abstract String getMenuLayoutFile();

    protected synchronized ApplicationMenu getAppMenu() {
        if (this.m_AppMenu == null) {
            this.m_AppMenu = new ApplicationMenu(this);
            this.m_AppMenu.setSetup(this.getMenuLayoutFile());
            this.m_AppMenu.setUserMode(this.getUserMode());
        }
        return this.m_AppMenu;
    }

    protected JMenuBar createMenuBar() {
        this.m_AppMenu = null;
        JMenuBar result = this.getAppMenu().getMenuBar();
        this.m_MenuWindows = this.getAppMenu().getWindowsMenu();
        return result;
    }

    protected ChildFrame createChildFrame(String title, Component c, int width, int height, String icon) {
        return AbstractApplicationFrame.createChildFrame(this, title, c, width, height, icon);
    }

    public static ChildFrame createChildFrame(AbstractApplicationFrame owner, String title, Component c, int width, int height, String icon) {
        ChildFrame result = new ChildFrame(owner, title, icon);
        result.setLayout(new BorderLayout());
        if (c != null) {
            result.getContentPane().add(c, "Center");
        }
        result.pack();
        if (width > -1 && height > -1) {
            result.setSize(width, height);
        }
        result.validate();
        if (owner != null) {
            int screenHeight = owner.getGraphicsConfiguration().getBounds().height;
            int screenWidth = owner.getGraphicsConfiguration().getBounds().width;
            result.setLocation((screenWidth - result.getBounds().width) / 2, (screenHeight - result.getBounds().height) / 2);
        }
        if (c != null) {
            GUIHelper.setSizeAndLocation(result, c);
        }
        result.addDisposeWindowListener();
        if (c != null && c instanceof MenuBarProvider) {
            result.setJMenuBar(((MenuBarProvider)((Object)c)).getMenuBar());
        }
        if (c != null && c instanceof ScriptingEngineHandler && c instanceof BasePanel) {
            ScriptingEngineHandler handler = (ScriptingEngineHandler)((Object)c);
            if (GUIHelper.getStartupScript(c) != null) {
                handler.getScriptingEngine().add((BasePanel)c, GUIHelper.getStartupScript(c));
            }
        }
        result.setVisible(true);
        return result;
    }

    protected ChildWindow createChildWindow(String title, Component c, int width, int height, String icon) {
        return AbstractApplicationFrame.createChildWindow(this, title, c, width, height, icon);
    }

    public static ChildWindow createChildWindow(AbstractApplicationFrame owner, String title, Component c, int width, int height, String icon) {
        ChildWindow result = new ChildWindow(owner, title, icon);
        result.setLayout(new BorderLayout());
        if (c != null) {
            result.getContentPane().add(c, "Center");
        }
        result.pack();
        if (width > -1 && height > -1) {
            result.setSize(width, height);
        }
        result.validate();
        if (owner != null) {
            int screenHeight = owner.getGraphicsConfiguration().getBounds().height;
            int screenWidth = owner.getGraphicsConfiguration().getBounds().width;
            result.setLocation((screenWidth - result.getBounds().width) / 2, (screenHeight - result.getBounds().height) / 2);
        }
        if (c != null) {
            GUIHelper.setSizeAndLocation(result, c);
        }
        result.addDisposeWindowListener();
        if (c != null && c instanceof ScriptingEngineHandler && c instanceof BasePanel) {
            ScriptingEngineHandler handler = (ScriptingEngineHandler)((Object)c);
            if (GUIHelper.getStartupScript(c) != null) {
                handler.getScriptingEngine().add((BasePanel)c, GUIHelper.getStartupScript(c));
            }
        }
        result.setVisible(true);
        return result;
    }

    protected void insertMenuItem(JMenu menu, JMenuItem menuitem) {
        this.insertMenuItem(menu, menuitem, 0);
    }

    protected void insertMenuItem(JMenu menu, JMenuItem menuitem, int startIndex) {
        boolean inserted = false;
        String newStr = menuitem.getText().toLowerCase();
        for (int i = startIndex; i < menu.getMenuComponentCount(); ++i) {
            JMenuItem current;
            String currentStr;
            if (!(menu.getMenuComponent(i) instanceof JMenuItem) || (currentStr = (current = (JMenuItem)menu.getMenuComponent(i)).getText().toLowerCase()).compareTo(newStr) <= 0) continue;
            inserted = true;
            menu.insert(menuitem, i);
            break;
        }
        if (!inserted) {
            menu.add(menuitem);
        }
    }

    public void createTitle(String title) {
        HashSet<AbstractDatabaseConnection> conns;
        String newTitle = this.getApplicationTitle();
        String name = InternetHelper.getLocalHostName();
        if (name != null) {
            newTitle = newTitle + "@" + name;
        }
        if ((conns = AbstractDatabaseConnection.getActiveConnectionObjects()).size() > 0) {
            HashSet<String> connsStr = new HashSet<String>();
            for (AbstractDatabaseConnection conn : conns) {
                connsStr.add(conn.toStringShort());
            }
            ArrayList connsList = new ArrayList(connsStr);
            Collections.sort(connsList);
            newTitle = newTitle + " " + connsList;
        } else {
            newTitle = newTitle + " [-not connected-]";
        }
        if (title.length() != 0) {
            newTitle = title.length() > 50 ? newTitle + " - " + title.substring(0, 50) + "..." : newTitle + " - " + title;
        }
        this.setTitle(newTitle);
    }

    public void addChildFrame(ChildFrame c) {
        this.m_Children.add(c);
        this.windowListChanged();
    }

    public void addChildWindow(ChildWindow c) {
        this.m_Children.add(c);
        this.windowListChanged();
    }

    public boolean removeChildFrame(Container c) {
        boolean result = this.m_Children.remove(c);
        this.windowListChanged();
        return result;
    }

    public boolean showWindow(Child c) {
        boolean result = false;
        if (c != null) {
            this.createTitle(c.getTitle());
            if (c instanceof ChildFrame) {
                ((ChildFrame)c).setExtendedState(0);
            }
            c.toFront();
            c.requestFocus();
            result = true;
        }
        return result;
    }

    public boolean showWindow(Class windowClass) {
        return this.showWindow(this.getWindow(windowClass));
    }

    public Iterator<Child> getWindowList() {
        return this.m_Children.iterator();
    }

    public Child getWindow(Class windowClass) {
        Child result = null;
        Iterator<Child> iter = this.getWindowList();
        while (iter.hasNext()) {
            Child current = iter.next();
            if (current.getClass() != windowClass) continue;
            result = current;
            break;
        }
        return result;
    }

    public Child getWindow(String title) {
        Child result = null;
        Iterator<Child> iter = this.getWindowList();
        while (iter.hasNext()) {
            Child current = iter.next();
            boolean found = current.getTitle().equals(title);
            if (!found) continue;
            result = current;
            break;
        }
        return result;
    }

    public boolean containsWindow(Class windowClass) {
        return this.getWindow(windowClass) != null;
    }

    public boolean containsWindow(String title) {
        return this.getWindow(title) != null;
    }

    public void minimizeWindows() {
        Iterator<Child> iter = this.getWindowList();
        while (iter.hasNext()) {
            Child child = iter.next();
            try {
                if (!(child instanceof ChildFrame)) continue;
                ((ChildFrame)child).setExtendedState(1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void restoreWindows() {
        Iterator<Child> iter = this.getWindowList();
        while (iter.hasNext()) {
            Child child = iter.next();
            try {
                if (!(child instanceof ChildFrame)) continue;
                ((ChildFrame)child).setExtendedState(0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void windowListChanged() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                AbstractApplicationFrame.this.buildWindowsMenu();
            }
        };
        SwingUtilities.invokeLater(run);
    }

    protected void buildWindowsMenu() {
        this.m_MenuWindows.removeAll();
        JMenuItem menuitem = new JMenuItem("Minimize");
        menuitem.setIcon(GUIHelper.getIcon("minimize.png"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AbstractApplicationFrame.this.minimizeWindows();
            }
        });
        this.m_MenuWindows.add(menuitem);
        menuitem = new JMenuItem("Restore");
        menuitem.setIcon(GUIHelper.getIcon("maximize.png"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AbstractApplicationFrame.this.restoreWindows();
            }
        });
        this.m_MenuWindows.add(menuitem);
        JMenu submenu = new JMenu("User mode");
        for (final UserMode um : UserMode.values()) {
            menuitem = new JMenuItem(um.toString());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractApplicationFrame.this.setUserMode(um);
                }
            });
            submenu.add(menuitem);
        }
        this.m_MenuWindows.addSeparator();
        int startIndex = this.m_MenuWindows.getMenuComponentCount() - 1;
        Iterator<Child> iter = this.getWindowList();
        this.m_MenuWindows.setVisible(iter.hasNext());
        while (iter.hasNext()) {
            List<Image> images;
            Child child = iter.next();
            menuitem = new JMenuItem(child.getTitle());
            boolean useEmpty = true;
            if (child instanceof Window && (images = ((Window)((Object)child)).getIconImages()).size() > 0) {
                useEmpty = false;
                menuitem.setIcon(new ImageIcon(images.get(0)));
            }
            if (useEmpty) {
                menuitem.setIcon(GUIHelper.getEmptyIcon());
            }
            this.insertMenuItem(this.m_MenuWindows, menuitem, startIndex);
            menuitem.setActionCommand(Integer.toString(child.hashCode()));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Iterator<Child> iter = AbstractApplicationFrame.this.getWindowList();
                    while (iter.hasNext()) {
                        Child child = iter.next();
                        String hashFrame = Integer.toString(child.hashCode());
                        if (!hashFrame.equals(evt.getActionCommand())) continue;
                        AbstractApplicationFrame.this.showWindow(child);
                        break;
                    }
                }
            });
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.repaint();
        }
    }

    @Override
    public AbstractDatabaseConnection getDatabaseConnection() {
        return this.m_DbConn;
    }

    @Override
    public void setDatabaseConnection(AbstractDatabaseConnection value) {
        this.m_DbConn = value;
    }

    @Override
    public void databaseConnectionStateChanged(DatabaseConnectionChangeEvent e) {
        this.createTitle("");
        if (e.getType() == DatabaseConnectionChangeEvent.EventType.CONNECT) {
            this.m_DbConn = e.getDatabaseConnection();
        }
    }

    protected void startUpMenuItems() {
        final ArrayList<AbstractMenuItemDefinition> items = new ArrayList<AbstractMenuItemDefinition>();
        for (int i = 0; i < this.m_StartUps.length; ++i) {
            AbstractMenuItemDefinition item = AbstractMenuItemDefinition.forCommandLine(this, this.m_StartUps[i].toString());
            if (this.getAppMenu().isBlacklisted(item.getClass())) {
                this.getLogger().severe(item.getClass() + " is blacklisted and cannot be displayed!");
                continue;
            }
            if (this.getUserMode().compareTo(item.getUserMode()) < 0) {
                this.getLogger().severe(item.getClass() + " requires at least user mode '" + this.getAppMenu().getUserMode() + "' (current: '" + this.getUserMode() + "')!");
                continue;
            }
            items.add(item);
        }
        if (items.size() > 0) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < items.size(); ++i) {
                        ((AbstractMenuItemDefinition)items.get(i)).launch();
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public ScriptingLogPanel getScriptingLogPanel() {
        return this.m_ScriptingLogPanel;
    }

    public static AbstractApplicationFrame runApplication(Class env, Class app, String[] options) {
        AbstractApplicationFrame result;
        Environment.setEnvironmentClass(env);
        LoggingHelper.useHandlerFromOptions(options);
        try {
            if (OptionUtils.helpRequested(options)) {
                System.out.println("Help requested...\n");
                result = AbstractApplicationFrame.forName(app.getName(), new String[0]);
                System.out.print("\n" + OptionUtils.list(result));
                LoggingHelper.outputHandlerOption();
                ScriptingEngine.stopAllEngines();
                result.dispose();
                result = null;
            } else {
                result = AbstractApplicationFrame.forName(app.getName(), options);
                Environment.getInstance().setApplicationFrame(result);
                if (result.getDatabaseConnection().isConnected()) {
                    AbstractIndexedTable.initTables(result.getDatabaseConnection());
                }
                result.getLogger().info("PID: " + ProcessUtils.getVirtualMachinePID());
                result.setVisible(true);
                result.startUpMenuItems();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractApplicationFrame forName(String classname, String[] options) {
        AbstractApplicationFrame result;
        try {
            result = (AbstractApplicationFrame)OptionUtils.forName(AbstractApplicationFrame.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractApplicationFrame forCommandLine(String cmdline) {
        return (AbstractApplicationFrame)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline);
    }
}

