/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.io.PlaceholderFile;
import adams.data.io.input.AbstractReportReader;
import adams.data.io.output.AbstractReportWriter;
import adams.data.report.Report;
import adams.gui.chooser.AbstractConfigurableExtensionFileFilterFileChooser;
import adams.gui.chooser.ExtensionFileFilterWithClass;
import adams.gui.core.GUIHelper;
import adams.gui.goe.GenericObjectEditorDialog;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public abstract class AbstractReportFileChooser<T extends Report, R extends AbstractReportReader, W extends AbstractReportWriter>
extends AbstractConfigurableExtensionFileFilterFileChooser<R, W> {
    private static final long serialVersionUID = -5373058011025481738L;
    protected static Hashtable<Class, List<ExtensionFileFilterWithClass>> m_ReaderFileFilters = new Hashtable();
    protected static Hashtable<Class, List<ExtensionFileFilterWithClass>> m_WriterFileFilters = new Hashtable();

    protected AbstractReportFileChooser() {
    }

    protected AbstractReportFileChooser(File currentDirectory) {
        super(currentDirectory);
    }

    protected AbstractReportFileChooser(String currentDirectory) {
        super(currentDirectory);
    }

    protected static void initFilters(AbstractReportFileChooser chooser, boolean reader, String[] classnames) {
        if (reader) {
            m_ReaderFileFilters.put(chooser.getClass(), new ArrayList());
        } else {
            m_WriterFileFilters.put(chooser.getClass(), new ArrayList());
        }
        for (int i = 0; i < classnames.length; ++i) {
            ExtensionFileFilterWithClass filter;
            String[] ext;
            String desc;
            Object converter;
            Class<?> cls;
            String classname = classnames[i];
            try {
                cls = Class.forName(classname);
                converter = cls.newInstance();
                if (reader) {
                    desc = ((AbstractReportReader)converter).getFormatDescription();
                    ext = ((AbstractReportReader)converter).getFormatExtensions();
                } else {
                    desc = ((AbstractReportWriter)converter).getFormatDescription();
                    ext = ((AbstractReportWriter)converter).getFormatExtensions();
                }
            }
            catch (Exception e) {
                cls = null;
                converter = null;
                ext = new String[]{};
                desc = "";
            }
            if (converter == null) continue;
            if (reader) {
                filter = new ExtensionFileFilterWithClass(classname, desc, ext);
                m_ReaderFileFilters.get(chooser.getClass()).add(filter);
                continue;
            }
            filter = new ExtensionFileFilterWithClass(classname, desc, ext);
            m_WriterFileFilters.get(chooser.getClass()).add(filter);
        }
    }

    @Override
    protected List<ExtensionFileFilterWithClass> getOpenFileFilters() {
        return m_ReaderFileFilters.get(this.getClass());
    }

    @Override
    protected List<ExtensionFileFilterWithClass> getSaveFileFilters() {
        return m_WriterFileFilters.get(this.getClass());
    }

    @Override
    protected abstract R getDefaultReader();

    @Override
    protected abstract W getDefaultWriter();

    @Override
    protected Class getReaderClass() {
        return AbstractReportReader.class;
    }

    @Override
    protected Class getWriterClass() {
        return AbstractReportWriter.class;
    }

    @Override
    public int showOpenDialog(Component parent) {
        int result = super.showOpenDialog(parent);
        if (result == 0 && this.m_CheckBoxOptions.isSelected()) {
            this.m_Editor.setValue(this.m_CurrentHandler);
            GenericObjectEditorDialog dialog = GenericObjectEditorDialog.createDialog(this, this.m_Editor);
            dialog.setLocationRelativeTo(GUIHelper.getParentComponent(this));
            dialog.setVisible(true);
            result = dialog.getResultType();
            if (result == 0) {
                this.m_CurrentHandler = this.m_Editor.getValue();
            }
        }
        return result;
    }

    @Override
    public int showSaveDialog(Component parent) {
        int result = super.showSaveDialog(parent);
        if (result == 0 && this.m_CheckBoxOptions.isSelected()) {
            GenericObjectEditorDialog dialog = GenericObjectEditorDialog.createDialog(this, this.m_Editor);
            dialog.setLocationRelativeTo(GUIHelper.getParentComponent(this));
            dialog.setVisible(true);
            result = dialog.getResultType();
            if (result == 0) {
                this.m_CurrentHandler = this.m_Editor.getValue();
            }
        }
        return result;
    }

    @Override
    protected void updateCurrentHandlerHook() {
        try {
            String classname = ((ExtensionFileFilterWithClass)this.getFileFilter()).getClassname();
            Object newHandler = Class.forName(classname).newInstance();
            if (this.m_CurrentHandler == null) {
                this.m_CurrentHandler = newHandler;
            } else if (!this.m_CurrentHandler.getClass().equals(newHandler.getClass())) {
                this.m_CurrentHandler = newHandler;
            }
            this.setFileSelectionMode(0);
        }
        catch (Exception e) {
            this.m_CurrentHandler = null;
            e.printStackTrace();
        }
    }

    @Override
    protected void configureCurrentHandlerHook(int dialogType) {
        PlaceholderFile selFile = this.getSelectedPlaceholderFile();
        if (this.m_CurrentHandler == null) {
            String classname = ((ExtensionFileFilterWithClass)this.getFileFilter()).getClassname();
            try {
                this.m_CurrentHandler = Class.forName(classname).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.m_CurrentHandler = null;
            }
            if (this.m_CurrentHandler == null) {
                return;
            }
        }
        if (selFile.isDirectory()) {
            return;
        }
        try {
            PlaceholderFile currFile = this.m_CurrentHandler instanceof AbstractReportReader ? ((AbstractReportReader)this.m_CurrentHandler).getInput() : ((AbstractReportWriter)this.m_CurrentHandler).getOutput();
            if (currFile == null || !((File)currFile).getAbsolutePath().equals(selFile.getAbsolutePath())) {
                if (this.m_CurrentHandler instanceof AbstractReportReader) {
                    ((AbstractReportReader)this.m_CurrentHandler).setInput(selFile);
                } else {
                    ((AbstractReportWriter)this.m_CurrentHandler).setOutput(selFile);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected boolean getFiltersInitialized() {
        return m_ReaderFileFilters.containsKey(this.getClass());
    }

    @Override
    public void setAllowGlobFilters(boolean value) {
    }
}

