/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.gui.chooser.FileChooserBookmarksPanel;
import adams.gui.core.GUIHelper;
import com.jidesoft.swing.FolderChooser;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public class BaseDirectoryChooser
extends FolderChooser {
    private static final long serialVersionUID = -7252242971482953986L;
    protected FileChooserBookmarksPanel m_PanelBookmarks;

    public BaseDirectoryChooser() {
        this.initialize();
    }

    public BaseDirectoryChooser(File currentDirectory) {
        super(currentDirectory.getAbsoluteFile());
        this.initialize();
    }

    public BaseDirectoryChooser(File currentDirectory, FileSystemView fsv) {
        super(currentDirectory.getAbsoluteFile(), fsv);
        this.initialize();
    }

    public BaseDirectoryChooser(FileSystemView fsv) {
        super(fsv);
        this.initialize();
    }

    public BaseDirectoryChooser(String currentDirectoryPath) {
        super(new PlaceholderFile(currentDirectoryPath).getAbsolutePath());
        this.initialize();
    }

    public BaseDirectoryChooser(String currentDirectoryPath, FileSystemView fsv) {
        super(new PlaceholderFile(currentDirectoryPath).getAbsolutePath(), fsv);
        this.initialize();
    }

    protected void initialize() {
        JComponent accessory;
        this.setRecentListVisible(false);
        if (GUIHelper.getBoolean("BaseDirectoryChooser.ShowBookmarks", false).booleanValue() && (accessory = this.createAccessoryPanel()) != null) {
            this.setAccessory(accessory);
        }
    }

    protected JComponent createAccessoryPanel() {
        this.m_PanelBookmarks = new FileChooserBookmarksPanel();
        this.m_PanelBookmarks.setOwner((JFileChooser)((Object)this));
        this.m_PanelBookmarks.setBorder(BorderFactory.createEmptyBorder(2, 5, 0, 0));
        return this.m_PanelBookmarks;
    }

    public void addChoosableFileFilter(FileFilter filter) {
    }

    public void setSelectedFile(File file) {
        File selFile = null;
        if (file != null) {
            selFile = new File(file.getAbsolutePath());
        }
        super.setSelectedFile(selFile);
    }

    public File getSelectedFile() {
        File result = super.getSelectedFile();
        if (result != null) {
            int pos = result.getPath().lastIndexOf("${");
            result = pos > -1 ? new PlaceholderFile(result.getPath().substring(pos)) : new PlaceholderFile(result);
        }
        return result;
    }

    public PlaceholderDirectory getSelectedDirectory() {
        PlaceholderDirectory result = null;
        File file = this.getSelectedFile();
        if (file != null) {
            result = new PlaceholderDirectory(file);
        }
        return result;
    }

    public void setSelectedFiles(File[] selectedFiles) {
        File[] files = null;
        if (selectedFiles != null) {
            files = new File[selectedFiles.length];
            for (int i = 0; i < selectedFiles.length; ++i) {
                files[i] = new File(selectedFiles[i].getAbsolutePath());
            }
        }
        super.setSelectedFiles(files);
    }

    public File[] getSelectedFiles() {
        File[] result = super.getSelectedFiles();
        for (int i = 0; i < result.length; ++i) {
            int pos = result[i].getPath().indexOf("${");
            result[i] = pos > -1 ? new PlaceholderFile(result[i].getPath().substring(pos)) : new PlaceholderFile(result[i]);
        }
        return result;
    }

    public PlaceholderDirectory[] getSelectedDirectories() {
        PlaceholderDirectory[] result = new PlaceholderDirectory[]{};
        File[] files = this.getSelectedFiles();
        if (files.length > 0) {
            result = new PlaceholderDirectory[files.length];
            for (int i = 0; i < files.length; ++i) {
                result[i] = new PlaceholderDirectory(files[i]);
            }
        }
        return result;
    }

    public File getCurrentDirectory() {
        File current = super.getCurrentDirectory();
        if (current == null) {
            return null;
        }
        return new PlaceholderFile(current);
    }

    public void setCurrentDirectory(File dir) {
        if (dir == null) {
            super.setCurrentDirectory(null);
        } else {
            super.setCurrentDirectory(new PlaceholderFile(dir).getAbsoluteFile());
        }
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        BaseDirectoryChooser chooser = new BaseDirectoryChooser();
        chooser.setCurrentDirectory(new PlaceholderFile("${TMP}"));
        if (chooser.showOpenDialog(null) == 0) {
            System.out.println(chooser.getSelectedFile());
        }
    }
}

