/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.io.PlaceholderDirectory;
import java.io.Serializable;

public class FileChooserBookmark
implements Serializable,
Comparable<FileChooserBookmark> {
    private static final long serialVersionUID = 4284430561284693010L;
    protected String m_Name;
    protected PlaceholderDirectory m_Directory;

    public FileChooserBookmark(PlaceholderDirectory dir) {
        this(dir.getAbsoluteFile().getName(), dir);
    }

    public FileChooserBookmark(String name, PlaceholderDirectory dir) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Name cannot be null or empty!");
        }
        if (dir == null) {
            throw new IllegalArgumentException("Directory cannot be null!");
        }
        this.m_Name = name;
        this.m_Directory = dir;
    }

    public String getName() {
        return this.m_Name;
    }

    public PlaceholderDirectory getDirectory() {
        return this.m_Directory;
    }

    @Override
    public int compareTo(FileChooserBookmark o) {
        return this.getName().compareTo(o.getName());
    }

    public boolean equals(Object obj) {
        if (obj instanceof FileChooserBookmark) {
            return this.compareTo((FileChooserBookmark)obj) == 0;
        }
        return false;
    }

    public String toString() {
        return this.m_Name;
    }
}

