/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.gui.core.BaseTreeNode;

public abstract class LazyExpansionTreeNode
extends BaseTreeNode {
    private static final long serialVersionUID = -3931549349098523711L;
    protected boolean m_ExpansionOccurred;

    public LazyExpansionTreeNode() {
    }

    public LazyExpansionTreeNode(Object userObject) {
        super(userObject);
    }

    public LazyExpansionTreeNode(Object userObject, boolean allowsChildren) {
        super(userObject, allowsChildren);
    }

    public void setExpansionOccurred(boolean value) {
        this.m_ExpansionOccurred = value;
    }

    public boolean getExpansionOccurred() {
        return this.m_ExpansionOccurred;
    }

    public boolean canExpand() {
        return false;
    }

    protected abstract boolean doExpand();

    public synchronized boolean expand() {
        boolean result = false;
        if (!this.m_ExpansionOccurred) {
            result = this.doExpand();
            this.m_ExpansionOccurred = true;
        }
        return result;
    }

    protected abstract void doReset();

    public synchronized boolean collapse() {
        boolean result = false;
        if (!this.m_ExpansionOccurred) {
            return result;
        }
        if (this.getChildCount() > 0) {
            this.removeAllChildren();
            result = true;
        }
        this.doReset();
        this.m_ExpansionOccurred = false;
        return result;
    }
}

