/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.NamedCounter;
import adams.core.Properties;
import adams.core.option.AbstractOption;
import adams.data.DecimalFormatString;
import adams.data.sequence.XYSequence;
import adams.data.sequence.XYSequencePoint;
import adams.data.sequence.XYSequencePointComparator;
import adams.env.Environment;
import adams.flow.sink.sequenceplotter.AbstractSequencePostProcessor;
import adams.flow.sink.sequenceplotter.AligningSequences;
import adams.flow.sink.sequenceplotter.SequencePlotterPanel;
import adams.gui.core.BasePanel;
import adams.gui.visualization.core.AxisPanelOptions;
import adams.gui.visualization.core.axis.AbstractTickGenerator;
import adams.gui.visualization.core.axis.FancyTickGenerator;
import adams.gui.visualization.core.axis.Type;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.sequence.PaintletWithFixedYRange;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;

public class MemoryMonitorPanel
extends BasePanel {
    private static final long serialVersionUID = 649755316726537053L;
    public static final String FILENAME = "MemoryMonitor.props";
    protected static Properties m_Properties;
    protected SequencePlotterPanel m_PlotPanel;
    protected AbstractSequencePostProcessor m_PostProcessor;
    protected boolean m_Running;
    protected Runnable m_Monitor;
    protected MemoryMXBean m_Memory;
    protected NamedCounter m_Counter;
    protected int m_Interval;
    protected double m_Divisor;

    @Override
    protected void initialize() {
        super.initialize();
        Properties props = MemoryMonitorPanel.getProperties();
        this.m_Memory = ManagementFactory.getMemoryMXBean();
        this.m_Counter = new NamedCounter();
        this.m_PostProcessor = new AligningSequences();
        ((AligningSequences)this.m_PostProcessor).setLimit(props.getInteger("Max", 200));
        this.m_Interval = props.getInteger("Interval", 1000);
        this.m_Divisor = props.getDouble("Divisor", 1048576.0);
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        Properties props = MemoryMonitorPanel.getProperties();
        this.m_PlotPanel = new SequencePlotterPanel(null);
        this.m_PlotPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        AxisPanelOptions options = new AxisPanelOptions();
        options.setLabel(props.getPath("Axis.Bottom.Title", "Time"));
        options.setType(Type.valueOf((AbstractOption)null, props.getPath("Axis.Bottom.Type", Type.TIME.toString())));
        options.setTickGenerator(AbstractTickGenerator.forCommandLine(props.getProperty("Axis.Bottom.TickGenerator", new FancyTickGenerator().toString())));
        options.setWidth(props.getInteger("Axis.Bottom.Width", 40));
        options.setNthValueToShow(props.getInteger("Axis.Bottom.NthValueToShow", 2));
        options.setCustomFormat(new DecimalFormatString(props.getPath("Axis.Bottom.Format", "HH:mm")));
        options.configure(this.m_PlotPanel.getPlot(), Axis.BOTTOM);
        options = new AxisPanelOptions();
        options.setLabel(props.getPath("Axis.Left.Title", "MB"));
        options.setType(Type.valueOf((AbstractOption)null, props.getPath("Axis.Left.Type", Type.ABSOLUTE.toString())));
        options.setTickGenerator(AbstractTickGenerator.forCommandLine(props.getProperty("Axis.Left.TickGenerator", new FancyTickGenerator().toString())));
        options.setWidth(props.getInteger("Axis.Left.Width", 80));
        options.setNthValueToShow(props.getInteger("Axis.Left.NthValueToShow", 2));
        options.setCustomFormat(new DecimalFormatString(props.getPath("Axis.Left.Format", "0")));
        options.configure(this.m_PlotPanel.getPlot(), Axis.LEFT);
        this.m_PlotPanel.getPlot().setZoomingEnabled(false);
        PaintletWithFixedYRange paintlet = new PaintletWithFixedYRange();
        paintlet.setMinY(0.0);
        paintlet.setMaxY(this.scale(this.m_Memory.getHeapMemoryUsage().getMax()));
        this.m_PlotPanel.setPaintlet(paintlet);
        this.add((Component)this.m_PlotPanel, "Center");
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        this.m_Monitor = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MemoryMonitorPanel.this.m_Running = true;
                while (MemoryMonitorPanel.this.m_Running) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MemoryMonitorPanel.this.update();
                        }
                    });
                    try {
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            this.wait(MemoryMonitorPanel.this.m_Interval);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        new Thread(this.m_Monitor).start();
    }

    protected double scale(double value) {
        return value / this.m_Divisor;
    }

    protected void add(XYSequenceContainerManager manager, String name, long value) {
        XYSequence seq;
        if (manager.indexOf(name) == -1) {
            seq = new XYSequence();
            seq.setComparison(XYSequencePointComparator.Comparison.X);
            seq.setID(name);
            XYSequenceContainer cont = manager.newContainer(seq);
            manager.add(cont);
        } else {
            XYSequenceContainer cont = (XYSequenceContainer)manager.get(manager.indexOf(name));
            seq = cont.getData();
        }
        XYSequencePoint point = new XYSequencePoint("" + System.currentTimeMillis(), new Double(System.currentTimeMillis()), new Double(this.scale(value)));
        seq.add(point);
        this.m_PostProcessor.postProcess(manager, name);
    }

    protected void update() {
        MemoryUsage usage = this.m_Memory.getHeapMemoryUsage();
        XYSequenceContainerManager manager = (XYSequenceContainerManager)this.m_PlotPanel.getContainerManager();
        manager.startUpdate();
        this.add(manager, "Used", usage.getUsed());
        this.add(manager, "Committed", usage.getCommitted());
        manager.finishUpdate();
    }

    public void stop() {
        this.m_Running = false;
    }

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("memory monitor");
        }
        return m_Properties;
    }
}

