/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.DateTime;
import adams.core.EnumHelper;
import adams.core.Properties;
import adams.core.Time;
import adams.core.Utils;
import adams.core.base.BaseString;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionUtils;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.gui.chooser.AbstractChooserPanel;
import adams.gui.chooser.ColorChooserPanel;
import adams.gui.chooser.DateChooserPanel;
import adams.gui.chooser.DateTimeChooserPanel;
import adams.gui.chooser.DirectoryChooserPanel;
import adams.gui.chooser.FileChooserPanel;
import adams.gui.chooser.FontChooserPanel;
import adams.gui.chooser.TimeChooserPanel;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.ParameterPanel;
import adams.gui.goe.FontEditor;
import adams.gui.goe.GenericArrayEditorPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.JTextField;

public class PropertiesParameterPanel
extends BasePanel {
    private static final long serialVersionUID = -822178750857036833L;
    public static final int DEFAULT_WIDTH_CHOOSERS = 250;
    protected ParameterPanel m_PanelProperties;
    protected List<String> m_Identifiers;
    protected Hashtable<String, PropertyType> m_PropertyTypes;
    protected Hashtable<String, PropertyType> m_ActualPropertyTypes;
    protected Hashtable<String, AbstractChooserPanel> m_Choosers;
    protected Hashtable<String, Class> m_Enums;
    protected Hashtable<String, String[]> m_Lists;
    protected Hashtable<String, String> m_Help;
    protected Hashtable<String, String> m_Label;
    protected List<String> m_Order;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Identifiers = new ArrayList<String>();
        this.m_PropertyTypes = new Hashtable();
        this.m_ActualPropertyTypes = new Hashtable();
        this.m_Choosers = new Hashtable();
        this.m_Enums = new Hashtable();
        this.m_Lists = new Hashtable();
        this.m_Help = new Hashtable();
        this.m_Label = new Hashtable();
        this.m_Order = new ArrayList<String>();
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PanelProperties = new ParameterPanel();
        this.add((Component)new BaseScrollPane(this.m_PanelProperties), "Center");
    }

    public void clearPropertyTypes() {
        this.m_PropertyTypes.clear();
        this.m_ActualPropertyTypes.clear();
        this.m_Choosers.clear();
        this.m_Enums.clear();
        this.m_Lists.clear();
        this.m_Help.clear();
    }

    protected void clearProperties() {
        this.m_Identifiers.clear();
        this.m_PanelProperties.clearParameters();
    }

    public void addProperty(String identifier, String label, Component comp) {
        if (this.m_Identifiers.contains(identifier)) {
            throw new IllegalArgumentException("Identifier '" + identifier + "' already present!");
        }
        this.m_Identifiers.add(identifier);
        this.m_PanelProperties.addParameter(label, comp);
    }

    public void addProperty(String identifier, String label, AbstractChooserPanel chooser) {
        if (this.m_Identifiers.contains(identifier)) {
            throw new IllegalArgumentException("Identifier '" + identifier + "' already present!");
        }
        this.m_Identifiers.add(identifier);
        this.m_PanelProperties.addParameter(label, (Component)chooser);
    }

    public Component getProperty(int index) {
        return this.m_PanelProperties.getParameter(index);
    }

    public Component getProperty(String identifier) {
        int index = this.m_Identifiers.indexOf(identifier);
        if (index == -1) {
            return null;
        }
        return this.m_PanelProperties.getParameter(index);
    }

    public int getPropertyCount() {
        return this.m_PanelProperties.getParameterCount();
    }

    public void addPropertyType(String property, PropertyType type) {
        this.m_PropertyTypes.put(property, type);
    }

    public boolean hasPropertyType(String property) {
        return this.m_PropertyTypes.containsKey(property);
    }

    public PropertyType getPropertyType(String property) {
        if (this.hasPropertyType(property)) {
            return this.m_PropertyTypes.get(property);
        }
        return PropertyType.STRING;
    }

    public PropertyType getActualPropertyType(String property) {
        if (this.m_ActualPropertyTypes.containsKey(property)) {
            return this.m_ActualPropertyTypes.get(property);
        }
        return PropertyType.STRING;
    }

    public void setPropertyOrder(List<String> value) {
        this.m_Order.clear();
        this.m_Order.addAll(value);
    }

    public List<String> getPropertyOrder() {
        return this.m_Order;
    }

    public boolean hasChooser(String property) {
        return this.m_Choosers.containsKey(property);
    }

    public void setChooser(String property, AbstractChooserPanel value) {
        this.m_Choosers.put(property, value);
    }

    public AbstractChooserPanel getChooser(String property) {
        return this.m_Choosers.get(property);
    }

    public boolean hasEnum(String property) {
        return this.m_Enums.containsKey(property);
    }

    public void setEnum(String property, Class value) {
        this.m_Enums.put(property, value);
    }

    public Class getEnum(String property) {
        return this.m_Enums.get(property);
    }

    public boolean hasList(String property) {
        return this.m_Lists.containsKey(property);
    }

    public void setList(String property, String[] value) {
        this.m_Lists.put(property, value);
    }

    public String[] getList(String property) {
        return this.m_Lists.get(property);
    }

    public boolean hasHelp(String property) {
        return this.m_Help.containsKey(property);
    }

    public void setHelp(String property, String value) {
        this.m_Help.put(property, value);
    }

    public String getHelp(String property) {
        return this.m_Help.get(property);
    }

    public boolean hasLabel(String property) {
        return this.m_Label.containsKey(property);
    }

    public void setLabel(String property, String value) {
        this.m_Label.put(property, value);
    }

    public String getLabel(String property) {
        return this.m_Label.get(property);
    }

    public void setProperties(Properties value) {
        this.clearProperties();
        ArrayList<String> keys = new ArrayList<String>(value.keySetAll());
        keys.removeAll(this.m_Order);
        Collections.sort(keys);
        keys.addAll(0, this.m_Order);
        block18: for (String key : keys) {
            PropertyType type = this.getPropertyType(key);
            String help = this.getHelp(key);
            if (type == PropertyType.OBJECT_EDITOR) {
                if (!this.hasChooser(key)) {
                    type = PropertyType.STRING;
                }
            } else if (type == PropertyType.ENUM) {
                if (!this.hasEnum(key)) {
                    type = PropertyType.STRING;
                }
            } else if (type == PropertyType.LIST && !this.hasList(key)) {
                type = PropertyType.STRING;
            }
            this.m_ActualPropertyTypes.put(key, type);
            String label = this.hasLabel(key) ? this.getLabel(key) : key;
            switch (type) {
                case TIME: {
                    TimeChooserPanel timePanel = new TimeChooserPanel();
                    timePanel.setCurrent(value.getTime(key));
                    timePanel.setToolTipText(help);
                    this.addProperty(key, label, timePanel);
                    continue block18;
                }
                case DATE: {
                    DateChooserPanel datePanel = new DateChooserPanel();
                    datePanel.setCurrent(value.getDate(key));
                    datePanel.setToolTipText(help);
                    this.addProperty(key, label, datePanel);
                    continue block18;
                }
                case DATETIME: {
                    DateTimeChooserPanel dateTimePanel = new DateTimeChooserPanel();
                    dateTimePanel.setCurrent(value.getDateTime(key));
                    dateTimePanel.setToolTipText(help);
                    this.addProperty(key, label, dateTimePanel);
                    continue block18;
                }
                case DOUBLE: 
                case STRING: {
                    JTextField textfield = new JTextField(20);
                    textfield.setText(value.getProperty(key));
                    textfield.setToolTipText(help);
                    this.addProperty(key, label, textfield);
                    continue block18;
                }
                case BOOLEAN: {
                    JCheckBox checkbox = new JCheckBox();
                    checkbox.setSelected(value.getBoolean(key));
                    checkbox.setToolTipText(help);
                    this.addProperty(key, label, checkbox);
                    continue block18;
                }
                case INTEGER: {
                    JSpinner spinner = new JSpinner();
                    spinner.setValue(value.getInteger(key));
                    spinner.setToolTipText(help);
                    this.addProperty(key, label, spinner);
                    continue block18;
                }
                case FONT: {
                    FontChooserPanel fontPanel = new FontChooserPanel();
                    fontPanel.setCurrent((Font)FontEditor.valueOf(null, value.getProperty(key)));
                    fontPanel.setToolTipText(help);
                    this.addProperty(key, label, fontPanel);
                    continue block18;
                }
                case DIRECTORY: {
                    DirectoryChooserPanel dirPanel = new DirectoryChooserPanel();
                    dirPanel.setCurrent(new PlaceholderDirectory(value.getPath(key)));
                    dirPanel.setPreferredSize(new Dimension(250, dirPanel.getPreferredSize().height));
                    dirPanel.setToolTipText(help);
                    this.addProperty(key, label, dirPanel);
                    continue block18;
                }
                case FILE: {
                    FileChooserPanel filePanel = new FileChooserPanel();
                    filePanel.setCurrent(new PlaceholderFile(value.getPath(key)));
                    filePanel.setPreferredSize(new Dimension(250, filePanel.getPreferredSize().height));
                    filePanel.setToolTipText(help);
                    this.addProperty(key, label, filePanel);
                    continue block18;
                }
                case COLOR: {
                    ColorChooserPanel colorPanel = new ColorChooserPanel();
                    colorPanel.setCurrent(value.getColor(key));
                    colorPanel.setToolTipText(help);
                    this.addProperty(key, label, colorPanel);
                    continue block18;
                }
                case ENUM: {
                    JComboBox<Object> combo = new JComboBox<Object>(EnumHelper.getValues(this.getEnum(key)));
                    combo.setSelectedItem(EnumHelper.parse(this.getEnum(key), value.getProperty(key)));
                    combo.setToolTipText(help);
                    this.addProperty(key, label, combo);
                    continue block18;
                }
                case LIST: 
                case BLANK_SEPARATED_LIST_FIXED: 
                case COMMA_SEPARATED_LIST_FIXED: {
                    JComboBox<Object> combo = type == PropertyType.BLANK_SEPARATED_LIST_FIXED ? new JComboBox<String>(SpreadSheetUtils.split(value.getProperty(key), ' ', true)) : (type == PropertyType.COMMA_SEPARATED_LIST_FIXED ? new JComboBox<String>(SpreadSheetUtils.split(value.getProperty(key), ',', true)) : new JComboBox<String>(this.getList(key)));
                    combo.setSelectedItem(value.getProperty(key));
                    combo.setToolTipText(help);
                    this.addProperty(key, label, combo);
                    continue block18;
                }
                case BLANK_SEPARATED_LIST: 
                case COMMA_SEPARATED_LIST: {
                    AbstractChooserPanel chooserPanel = new GenericArrayEditorPanel(new BaseString[0]);
                    chooserPanel.setPreferredSize(new Dimension(250, chooserPanel.getPreferredSize().height));
                    String[] parts = type == PropertyType.BLANK_SEPARATED_LIST ? SpreadSheetUtils.split(value.getProperty(key), ' ', true) : SpreadSheetUtils.split(value.getProperty(key), ',', true);
                    BaseString[] list = new BaseString[parts.length];
                    for (int i = 0; i < parts.length; ++i) {
                        list[i] = new BaseString(parts[i]);
                    }
                    chooserPanel.setCurrent(list);
                    this.addProperty(key, label, chooserPanel);
                    continue block18;
                }
                case OBJECT_EDITOR: {
                    AbstractChooserPanel chooserPanel = this.getChooser(key);
                    chooserPanel.setPreferredSize(new Dimension(250, chooserPanel.getPreferredSize().height));
                    chooserPanel.setToolTipText(help);
                    try {
                        if (value.getProperty(key).trim().length() > 0) {
                            chooserPanel.setCurrent(OptionUtils.forAnyCommandLine(Object.class, value.getProperty(key)));
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Failed to instantiate: " + value.getProperty(key));
                        e.printStackTrace();
                    }
                    this.addProperty(key, label, chooserPanel);
                    continue block18;
                }
            }
            throw new IllegalStateException("Unhandled property type (property '" + keys + "'): " + (Object)((Object)type));
        }
    }

    public Properties getProperties() {
        Properties result = new Properties();
        block16: for (int i = 0; i < this.getPropertyCount(); ++i) {
            Component comp = this.getProperty(i);
            String key = this.m_Identifiers.get(i);
            PropertyType type = this.getActualPropertyType(key);
            switch (type) {
                case TIME: {
                    TimeChooserPanel timePanel = (TimeChooserPanel)comp;
                    result.setTime(key, (Time)timePanel.getCurrent());
                    continue block16;
                }
                case DATE: {
                    DateChooserPanel datePanel = (DateChooserPanel)comp;
                    result.setDate(key, (Date)datePanel.getCurrent());
                    continue block16;
                }
                case DATETIME: {
                    DateTimeChooserPanel dateTimePanel = (DateTimeChooserPanel)comp;
                    result.setDateTime(key, (DateTime)dateTimePanel.getCurrent());
                    continue block16;
                }
                case DOUBLE: 
                case STRING: {
                    JTextField textfield = (JTextField)comp;
                    result.setProperty(key, textfield.getText());
                    continue block16;
                }
                case BOOLEAN: {
                    JCheckBox checkbox = (JCheckBox)comp;
                    result.setBoolean(key, checkbox.isSelected());
                    continue block16;
                }
                case INTEGER: {
                    JSpinner spinner = (JSpinner)comp;
                    result.setInteger(key, ((Number)spinner.getValue()).intValue());
                    continue block16;
                }
                case FONT: {
                    FontChooserPanel fontPanel = (FontChooserPanel)comp;
                    result.setProperty(key, FontEditor.toString(null, fontPanel.getCurrent()));
                    continue block16;
                }
                case DIRECTORY: {
                    DirectoryChooserPanel dirPanel = (DirectoryChooserPanel)comp;
                    result.setPath(key, ((File)dirPanel.getCurrent()).getAbsolutePath());
                    continue block16;
                }
                case FILE: {
                    FileChooserPanel filePanel = (FileChooserPanel)comp;
                    result.setPath(key, ((File)filePanel.getCurrent()).getAbsolutePath());
                    continue block16;
                }
                case COLOR: {
                    ColorChooserPanel colorPanel = (ColorChooserPanel)comp;
                    result.setColor(key, (Color)colorPanel.getCurrent());
                    continue block16;
                }
                case ENUM: {
                    JComboBox comboEnum = (JComboBox)comp;
                    if (comboEnum.getSelectedIndex() <= -1) continue block16;
                    result.setProperty(key, "" + comboEnum.getSelectedItem());
                    continue block16;
                }
                case LIST: 
                case BLANK_SEPARATED_LIST_FIXED: 
                case COMMA_SEPARATED_LIST_FIXED: {
                    JComboBox comboEnum = (JComboBox)comp;
                    if (comboEnum.getSelectedIndex() <= -1) continue block16;
                    result.setProperty(key, "" + comboEnum.getSelectedItem());
                    continue block16;
                }
                case BLANK_SEPARATED_LIST: 
                case COMMA_SEPARATED_LIST: {
                    AbstractChooserPanel chooserPanel = (AbstractChooserPanel)comp;
                    Object[] list = (BaseString[])chooserPanel.getCurrent();
                    if (type == PropertyType.BLANK_SEPARATED_LIST) {
                        result.setProperty(key, Utils.flatten(list, " "));
                        continue block16;
                    }
                    result.setProperty(key, Utils.flatten(list, ","));
                    continue block16;
                }
                case OBJECT_EDITOR: {
                    AbstractChooserPanel chooserPanel = (AbstractChooserPanel)comp;
                    result.setProperty(key, OptionUtils.getCommandLine(chooserPanel.getCurrent()));
                    continue block16;
                }
                default: {
                    throw new IllegalStateException("Unhandled property type (property '" + key + "'): " + (Object)((Object)type));
                }
            }
        }
        return result;
    }

    public static enum PropertyType {
        BOOLEAN,
        INTEGER,
        DOUBLE,
        STRING,
        TIME,
        DATE,
        DATETIME,
        COLOR,
        FONT,
        FILE,
        DIRECTORY,
        ENUM,
        LIST,
        COMMA_SEPARATED_LIST,
        COMMA_SEPARATED_LIST_FIXED,
        BLANK_SEPARATED_LIST,
        BLANK_SEPARATED_LIST_FIXED,
        OBJECT_EDITOR;

    }
}

