/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow;

import adams.core.Pausable;
import adams.core.Properties;
import adams.core.StatusMessageHandler;
import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.core.net.HtmlUtils;
import adams.data.io.input.FlowReader;
import adams.db.LogEntryHandler;
import adams.env.Environment;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorUtils;
import adams.flow.standalone.SetVariable;
import adams.flow.standalone.Standalones;
import adams.gui.action.AbstractBaseAction;
import adams.gui.action.ToggleAction;
import adams.gui.application.ChildFrame;
import adams.gui.application.ChildWindow;
import adams.gui.core.BaseDialog;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseStatusBar;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.RecentFilesHandler;
import adams.gui.core.TitleGenerator;
import adams.gui.core.ToolBarPanel;
import adams.gui.event.RecentItemEvent;
import adams.gui.event.RecentItemListener;
import adams.gui.flow.FlowFileChooser;
import adams.gui.tools.LogEntryViewerPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FlowRunnerPanel
extends ToolBarPanel
implements MenuBarProvider,
StatusMessageHandler {
    private static final long serialVersionUID = -4599322589770009727L;
    public static final String FILENAME = "FlowRunner.props";
    public static final String SESSION_FILE = "FlowRunnerSession.props";
    protected static Properties m_Properties;
    protected boolean m_Running;
    protected boolean m_Stopping;
    protected boolean m_RunningSwingWorker;
    protected AbstractActor m_CurrentFlow;
    protected File m_CurrentFile;
    protected FlowFileChooser m_FileChooser;
    protected BaseStatusBar m_StatusBar;
    protected FlowRunnerPanel m_Self;
    protected TitleGenerator m_TitleGenerator;
    protected JMenuBar m_MenuBar;
    protected AbstractBaseAction m_ActionLoad;
    protected JMenu m_MenuItemLoadRecent;
    protected AbstractBaseAction m_ActionClose;
    protected AbstractBaseAction m_ActionHeadless;
    protected AbstractBaseAction m_ActionRun;
    protected AbstractBaseAction m_ActionPauseAndResume;
    protected AbstractBaseAction m_ActionStop;
    protected AbstractBaseAction m_ActionExecutionLogErrors;
    protected AbstractBaseAction m_ActionExecutionDisplayErrors;
    protected AbstractBaseAction m_ActionNewWindow;
    protected AbstractBaseAction m_ActionDuplicateWindow;
    protected RecentFilesHandler<JMenu> m_RecentFilesHandler;
    protected BaseScrollPane m_ParameterScrollPane;
    protected JPanel m_PanelParameters;
    protected JLabel m_LabelFlowAnnotation;
    protected Vector<SetVariable> m_CurrentSetVariables;
    protected Vector<JTextField> m_CurrentParameters;
    protected Vector<JButton> m_CurrentHelpButtons;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Self = this;
        this.m_CurrentFlow = null;
        this.m_CurrentFile = null;
        this.m_RecentFilesHandler = null;
        this.m_TitleGenerator = new TitleGenerator("Flow runner", true);
        this.m_CurrentSetVariables = new Vector();
        this.m_CurrentParameters = new Vector();
        this.m_CurrentHelpButtons = new Vector();
        this.m_FileChooser = new FlowFileChooser();
        this.m_FileChooser.setCurrentDirectory(new PlaceholderFile(FlowRunnerPanel.getProperties().getPath("InitialDir", "%h")));
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        Properties props = FlowRunnerPanel.getProperties();
        this.setToolBarLocation(ToolBarPanel.ToolBarLocation.valueOf(props.getProperty("ToolBar.Location", "NORTH")));
        this.getContentPanel().setLayout(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        this.m_LabelFlowAnnotation = new JLabel();
        this.m_PanelParameters = new JPanel();
        this.m_ParameterScrollPane = new BaseScrollPane(this.m_PanelParameters);
        this.m_ParameterScrollPane.setBorder(BorderFactory.createEmptyBorder());
        panel.add((Component)this.m_ParameterScrollPane, "Center");
        panel.add((Component)this.m_LabelFlowAnnotation, "North");
        this.getContentPanel().add((Component)panel, "Center");
        this.m_StatusBar = new BaseStatusBar();
        this.m_StatusBar.setDialogSize(new Dimension(props.getInteger("StatusBar.Width", 600), props.getInteger("StatusBar.Height", 400)));
        this.m_StatusBar.setMouseListenerActive(true);
        this.m_StatusBar.setStatusProcessor(new BaseStatusBar.StatusProcessor(){

            @Override
            public String process(String msg) {
                return msg.replace(": ", ":\n");
            }
        });
        this.getContentPanel().add((Component)this.m_StatusBar, "South");
        this.reset();
    }

    @Override
    protected void initActions() {
        AbstractBaseAction action = new AbstractBaseAction("Open...", "open.gif"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowRunnerPanel.this.open();
            }
        };
        action.setMnemonic(79);
        action.setAccelerator("ctrl pressed O");
        this.m_ActionLoad = action;
        action = new AbstractBaseAction("Close", "exit.png"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowRunnerPanel.this.close();
            }
        };
        action.setMnemonic(67);
        action.setAccelerator("ctrl pressed Q");
        this.m_ActionClose = action;
        action = new AbstractBaseAction("Run", "run.gif"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowRunnerPanel.this.run();
            }
        };
        action.setMnemonic(82);
        action.setAccelerator("ctrl pressed R");
        this.m_ActionRun = action;
        action = new AbstractBaseAction("Pause", "pause.gif"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowRunnerPanel.this.pauseAndResume();
            }
        };
        action.setMnemonic(85);
        action.setAccelerator("ctrl pressed P");
        this.m_ActionPauseAndResume = action;
        action = new AbstractBaseAction("Stop", "stop_blue.gif"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowRunnerPanel.this.stop();
            }
        };
        action.setMnemonic(83);
        action.setAccelerator("ctrl pressed K");
        this.m_ActionStop = action;
        action = new AbstractBaseAction("Log errors"){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        action.setMnemonic(76);
        action.setSelected(false);
        this.m_ActionExecutionLogErrors = action;
        action = new AbstractBaseAction("Display errors", "log.gif"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowRunnerPanel.this.displayErrors();
            }
        };
        action.setMnemonic(68);
        this.m_ActionExecutionDisplayErrors = action;
        action = new ToggleAction("Headless", GUIHelper.getEmptyIcon());
        action.setMnemonic(72);
        action.setAccelerator("ctrl pressed H");
        this.m_ActionHeadless = action;
        action = new AbstractBaseAction("New window", "new.gif"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowRunnerPanel.this.newWindow();
            }
        };
        action.setMnemonic(87);
        this.m_ActionNewWindow = action;
        action = new AbstractBaseAction("Duplicate window", "copy.gif"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowRunnerPanel.this.duplicateWindow();
            }
        };
        action.setMnemonic(68);
        this.m_ActionDuplicateWindow = action;
    }

    @Override
    protected void initToolBar() {
        this.addToToolBar(this.m_ActionLoad);
        this.addToToolBar(this.m_ActionRun);
        this.addToToolBar(this.m_ActionPauseAndResume);
        this.addToToolBar(this.m_ActionStop);
    }

    @Override
    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            if (this.getParentFrame() != null) {
                JFrame frame = (JFrame)this.getParentFrame();
                frame.setDefaultCloseOperation(0);
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        FlowRunnerPanel.this.close();
                    }
                });
            } else if (this.getParentDialog() != null) {
                JDialog dialog = (JDialog)this.getParentDialog();
                dialog.setDefaultCloseOperation(0);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        FlowRunnerPanel.this.close();
                    }
                });
            }
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    FlowRunnerPanel.this.updateActions();
                }
            });
            menu.add(new JMenuItem(this.m_ActionLoad));
            JMenu submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentFilesHandler = new RecentFilesHandler<JMenu>(SESSION_FILE, FlowRunnerPanel.getProperties().getInteger("MaxRecentFlows", 5), submenu);
            this.m_RecentFilesHandler.addRecentItemListener(new RecentItemListener<JMenu, File>(){

                @Override
                public void recentItemAdded(RecentItemEvent<JMenu, File> e) {
                }

                @Override
                public void recentItemSelected(RecentItemEvent<JMenu, File> e) {
                    FlowRunnerPanel.this.load(FlowRunnerPanel.this.m_FileChooser.getReaderForFile(e.getItem()), e.getItem());
                }
            });
            this.m_MenuItemLoadRecent = submenu;
            menu.addSeparator();
            menu.add(new JMenuItem(this.m_ActionClose));
            menu = new JMenu("Execution");
            result.add(menu);
            menu.setMnemonic('E');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    FlowRunnerPanel.this.updateActions();
                }
            });
            menu.add(new JMenuItem(this.m_ActionRun));
            menu.add(new JMenuItem(this.m_ActionPauseAndResume));
            menu.add(new JMenuItem(this.m_ActionStop));
            menu.add(new JCheckBoxMenuItem(this.m_ActionExecutionLogErrors));
            menu.add(new JMenuItem(this.m_ActionExecutionDisplayErrors));
            menu.addSeparator();
            menu.add(new JCheckBoxMenuItem(this.m_ActionHeadless));
            if (GUIHelper.getParent(this.m_Self, ChildFrame.class) != null && this.getParentDialog() == null) {
                menu = new JMenu("Window");
                result.add(menu);
                menu.setMnemonic('W');
                menu.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        FlowRunnerPanel.this.updateActions();
                    }
                });
                menu.add(new JMenuItem(this.m_ActionNewWindow));
                menu.add(new JMenuItem(this.m_ActionDuplicateWindow));
            }
            this.m_MenuBar = result;
            this.updateActions();
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    @Override
    protected void updateActions() {
        this.updateTitle();
        if (this.m_MenuBar == null) {
            return;
        }
        boolean inputEnabled = !this.m_Running && !this.m_Stopping && !this.m_RunningSwingWorker;
        Pausable pausable = this.m_CurrentFlow != null && this.m_CurrentFlow instanceof Pausable ? (Pausable)((Object)this.m_CurrentFlow) : null;
        this.m_ActionLoad.setEnabled(inputEnabled);
        this.m_MenuItemLoadRecent.setEnabled(inputEnabled && this.m_RecentFilesHandler.size() > 0);
        this.m_ActionClose.setEnabled(inputEnabled);
        this.m_ActionRun.setEnabled(inputEnabled && this.m_CurrentFlow instanceof Flow);
        if (pausable != null && pausable.isPaused()) {
            this.m_ActionPauseAndResume.setIcon(GUIHelper.getIcon("resume.gif"));
            this.m_ActionPauseAndResume.setName("Resume");
        } else {
            this.m_ActionPauseAndResume.setIcon(GUIHelper.getIcon("pause.gif"));
            this.m_ActionPauseAndResume.setName("Pause");
        }
        this.m_ActionPauseAndResume.setEnabled(this.m_Running);
        this.m_ActionStop.setEnabled(this.m_Running);
        this.m_ActionHeadless.setEnabled(inputEnabled);
        this.m_ActionExecutionLogErrors.setEnabled(inputEnabled);
        this.m_ActionExecutionDisplayErrors.setEnabled(inputEnabled && this.m_CurrentFlow != null && this.m_CurrentFlow instanceof LogEntryHandler && ((LogEntryHandler)((Object)this.m_CurrentFlow)).countLogEntries() > 0);
    }

    protected void updateWidgets() {
        boolean inputEnabled = !this.m_Running && !this.m_Stopping;
        this.m_PanelParameters.setEnabled(inputEnabled);
        for (int i = 0; i < this.m_CurrentParameters.size(); ++i) {
            this.m_CurrentParameters.get(i).setEnabled(inputEnabled);
            if (this.m_CurrentHelpButtons.get(i) == null) continue;
            this.m_CurrentHelpButtons.get(i).setEnabled(inputEnabled);
        }
    }

    protected void update() {
        this.updateActions();
        this.updateWidgets();
        this.updateTitle();
        this.updateAnnotation();
        this.updateParameters();
    }

    protected void findSetVariableActors(AbstractActor parent, Vector<SetVariable> list) {
        if (parent instanceof ActorHandler) {
            for (int i = 0; i < ((ActorHandler)((Object)parent)).size(); ++i) {
                AbstractActor actor = ((ActorHandler)((Object)parent)).get(i);
                if (actor instanceof SetVariable) {
                    list.add((SetVariable)actor);
                    continue;
                }
                if (!(actor instanceof Standalones)) continue;
                this.findSetVariableActors(actor, list);
            }
        }
    }

    protected void updateAnnotation() {
        this.m_LabelFlowAnnotation.setBorder(null);
        this.m_LabelFlowAnnotation.setText("");
        if (this.m_CurrentFlow != null && !this.m_CurrentFlow.getAnnotations().isEmpty()) {
            this.m_LabelFlowAnnotation.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.m_LabelFlowAnnotation.setText("<html>" + HtmlUtils.toHTML(this.m_CurrentFlow.getAnnotations().getValue()).replaceAll("\n", "<br>") + "</html>");
        }
    }

    protected void updateParameters() {
        this.m_PanelParameters.removeAll();
        this.m_CurrentSetVariables.clear();
        this.m_CurrentParameters.clear();
        this.m_CurrentHelpButtons.clear();
        if (this.m_CurrentFlow == null) {
            this.m_ParameterScrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.m_PanelParameters.setLayout(new BorderLayout());
            this.m_PanelParameters.add((Component)new JLabel("No parameters to configure", 0), "Center");
        } else {
            int i;
            this.m_ParameterScrollPane.setBorder(BorderFactory.createTitledBorder("Available parameters"));
            this.findSetVariableActors(this.m_CurrentFlow, this.m_CurrentSetVariables);
            this.m_PanelParameters.setLayout(new GridLayout(this.m_CurrentSetVariables.size() + 1, 2));
            String[] labels = new String[this.m_CurrentSetVariables.size()];
            for (i = 0; i < this.m_CurrentSetVariables.size(); ++i) {
                labels[i] = this.m_CurrentSetVariables.get(i).getVariableName().getValue();
            }
            char[] mnemonics = GUIHelper.getMnemonics(labels);
            for (i = 0; i < this.m_CurrentSetVariables.size(); ++i) {
                JTextField textfield = new JTextField(15);
                textfield.setText(this.m_CurrentSetVariables.get(i).getVariableValue());
                JButton buttonHelp = null;
                final String annotation = this.m_CurrentSetVariables.get(i).getAnnotations().getValue();
                final String variable = this.m_CurrentSetVariables.get(i).getVariableName().getValue();
                if (annotation.length() > 0) {
                    buttonHelp = new JButton(GUIHelper.getIcon("help2.png"));
                    buttonHelp.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            GUIHelper.showInformationMessage(FlowRunnerPanel.this, annotation, "Information on '" + variable + "'");
                        }
                    });
                }
                JPanel panel = new JPanel(new FlowLayout(0));
                panel.add(textfield);
                if (buttonHelp != null) {
                    panel.add(buttonHelp);
                }
                this.m_CurrentParameters.add(textfield);
                this.m_CurrentHelpButtons.add(buttonHelp);
                JLabel label = new JLabel(labels[i]);
                label.setDisplayedMnemonic(mnemonics[i]);
                label.setLabelFor(textfield);
                this.m_PanelParameters.add(label);
                this.m_PanelParameters.add(panel);
            }
            this.m_PanelParameters.revalidate();
        }
    }

    protected void updateTitle() {
        this.setParentTitle(this.m_TitleGenerator.generate(this.m_CurrentFile));
    }

    protected void setCurrentFile(File value) {
        this.m_CurrentFile = value;
    }

    public File getCurrentFile() {
        return this.m_CurrentFile;
    }

    public void loadUnsafe(File file) {
        if (!file.exists()) {
            this.reset();
            this.setCurrentFile(new File(file.getAbsolutePath()));
            this.updateActions();
        } else {
            this.load(this.m_FileChooser.getReaderForFile(file), file);
        }
    }

    protected void load(final FlowReader reader, final File file) {
        this.m_RunningSwingWorker = true;
        SwingWorker worker = new SwingWorker(){
            AbstractActor m_Flow;
            List<String> m_Errors;
            List<String> m_Warnings;

            protected Object doInBackground() throws Exception {
                FlowRunnerPanel.this.cleanUp(true);
                FlowRunnerPanel.this.update();
                FlowRunnerPanel.this.showStatus("Loading '" + file + "'...");
                this.m_Errors = new ArrayList<String>();
                this.m_Warnings = new ArrayList<String>();
                this.m_Flow = (AbstractActor)reader.read(file);
                this.m_Errors.addAll(reader.getErrors());
                this.m_Warnings.addAll(reader.getWarnings());
                if (!this.m_Errors.isEmpty()) {
                    this.m_Flow = null;
                }
                FlowRunnerPanel.this.setCurrentFlow(this.m_Flow);
                FlowRunnerPanel.this.showStatus("");
                return null;
            }

            @Override
            protected void done() {
                FlowRunnerPanel.this.m_RunningSwingWorker = false;
                if (this.m_Flow == null) {
                    if (this.m_Errors.isEmpty()) {
                        GUIHelper.showErrorMessage(FlowRunnerPanel.this.m_Self, "Failed to load flow '" + file + "'!");
                    } else {
                        GUIHelper.showErrorMessage(FlowRunnerPanel.this.m_Self, "Failed to load flow '" + file + "':\n" + Utils.flatten(this.m_Errors, "\n"));
                    }
                } else {
                    FlowRunnerPanel.this.setCurrentFile(file);
                    FlowRunnerPanel.this.setCurrentDirectory(file.getParentFile());
                    if (FlowRunnerPanel.this.m_RecentFilesHandler != null) {
                        FlowRunnerPanel.this.m_RecentFilesHandler.addRecentItem(file);
                    }
                    if (!this.m_Warnings.isEmpty()) {
                        GUIHelper.showErrorMessage(FlowRunnerPanel.this.m_Self, "Warning(s) encountered while loading flow '" + file + "':\n" + Utils.flatten(this.m_Warnings, "\n"));
                    }
                }
                FlowRunnerPanel.this.update();
                super.done();
            }
        };
        worker.execute();
    }

    protected void reset() {
        this.cleanUp(true);
        this.m_CurrentFlow = null;
        this.m_CurrentFile = null;
        this.updateActions();
        this.updateParameters();
    }

    public void setCurrentFlow(AbstractActor flow) {
        this.m_CurrentFile = null;
        this.m_CurrentFlow = flow;
    }

    public AbstractActor getCurrentFlow() {
        return this.m_CurrentFlow;
    }

    protected void open() {
        int retVal = this.m_FileChooser.showOpenDialog(this);
        if (retVal != 0) {
            return;
        }
        this.load((FlowReader)this.m_FileChooser.getReader(), this.m_FileChooser.getSelectedPlaceholderFile());
    }

    public void run() {
        this.run(true);
    }

    public void run(boolean showNotification) {
        final boolean fShowNotification = showNotification;
        this.m_Running = true;
        SwingWorker worker = new SwingWorker(){
            String m_Output;

            protected Object doInBackground() throws Exception {
                FlowRunnerPanel.this.updateWidgets();
                FlowRunnerPanel.this.updateActions();
                FlowRunnerPanel.this.cleanUp(false);
                try {
                    FlowRunnerPanel.this.showStatus("Initializing");
                    for (int i = 0; i < FlowRunnerPanel.this.m_CurrentParameters.size(); ++i) {
                        FlowRunnerPanel.this.m_CurrentSetVariables.get(i).setVariableValue(FlowRunnerPanel.this.m_CurrentParameters.get(i).getText());
                    }
                    if (FlowRunnerPanel.this.m_CurrentFlow instanceof Flow) {
                        ((Flow)FlowRunnerPanel.this.m_CurrentFlow).setParentComponent(FlowRunnerPanel.this);
                    }
                    if (FlowRunnerPanel.this.m_ActionHeadless != null) {
                        FlowRunnerPanel.this.m_CurrentFlow.setHeadless(FlowRunnerPanel.this.m_ActionHeadless.isSelected());
                    }
                    if (FlowRunnerPanel.this.m_ActionExecutionLogErrors != null && FlowRunnerPanel.this.m_CurrentFlow instanceof Flow && FlowRunnerPanel.this.m_ActionExecutionLogErrors.isSelected()) {
                        ((Flow)FlowRunnerPanel.this.m_CurrentFlow).setLogErrors(true);
                    }
                    FlowRunnerPanel.this.m_CurrentFlow = ActorUtils.removeDisabledActors(FlowRunnerPanel.this.m_CurrentFlow);
                    this.m_Output = FlowRunnerPanel.this.m_CurrentFlow.setUp();
                    if (this.m_Output == null && !FlowRunnerPanel.this.m_CurrentFlow.isStopped()) {
                        FlowRunnerPanel.this.showStatus("Running");
                        this.m_Output = FlowRunnerPanel.this.m_CurrentFlow.execute();
                    }
                    FlowRunnerPanel.this.showStatus("Finishing up");
                    FlowRunnerPanel.this.m_CurrentFlow.wrapUp();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    this.m_Output = Utils.throwableToString(e);
                }
                return "Done!";
            }

            @Override
            protected void done() {
                int countErrors;
                super.done();
                String errors = null;
                if (FlowRunnerPanel.this.m_CurrentFlow instanceof LogEntryHandler && (countErrors = ((LogEntryHandler)((Object)FlowRunnerPanel.this.m_CurrentFlow)).countLogEntries()) > 0) {
                    errors = countErrors + " error(s) logged";
                }
                if (this.m_Output != null) {
                    String msg = "Finished with error: " + this.m_Output;
                    if (errors != null) {
                        msg = msg + "(" + errors + ")";
                    }
                    FlowRunnerPanel.this.showStatus(msg);
                    if (fShowNotification) {
                        FlowRunnerPanel.this.showMessage(this.m_Output);
                    }
                } else {
                    String msg = FlowRunnerPanel.this.m_Running ? "Flow finished." : "User stopped flow.";
                    if (errors != null) {
                        msg = msg + " " + errors + ".";
                    }
                    FlowRunnerPanel.this.showStatus(msg);
                    if (fShowNotification) {
                        if (FlowRunnerPanel.this.m_Running) {
                            GUIHelper.showInformationMessage(FlowRunnerPanel.this.m_Self, msg);
                        } else {
                            GUIHelper.showErrorMessage(FlowRunnerPanel.this.m_Self, msg);
                        }
                    }
                }
                FlowRunnerPanel.this.m_Running = false;
                FlowRunnerPanel.this.m_Stopping = false;
                FlowRunnerPanel.this.updateWidgets();
                FlowRunnerPanel.this.updateActions();
            }
        };
        worker.execute();
    }

    public boolean isRunning() {
        return this.m_Running;
    }

    public boolean isStopping() {
        return this.m_Stopping;
    }

    public boolean isRunningSwingWorker() {
        return this.m_RunningSwingWorker;
    }

    protected void pauseAndResume() {
        Pausable pausable = (Pausable)((Object)this.m_CurrentFlow);
        if (!pausable.isPaused()) {
            this.showStatus("Pausing");
            this.m_ActionPauseAndResume.setName("Resume");
            pausable.pauseExecution();
        } else {
            this.showStatus("Resuming");
            this.m_ActionPauseAndResume.setName("Pause");
            pausable.resumeExecution();
        }
        this.updateActions();
    }

    public void stop() {
        this.showStatus("Stopping");
        this.m_Running = false;
        this.m_Stopping = true;
        this.updateActions();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FlowRunnerPanel.this.m_CurrentFlow.stopExecution();
                FlowRunnerPanel.this.updateActions();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void displayErrors() {
        if (this.m_CurrentFlow == null) {
            return;
        }
        if (!(this.m_CurrentFlow instanceof LogEntryHandler)) {
            return;
        }
        LogEntryHandler handler = (LogEntryHandler)((Object)this.m_CurrentFlow);
        if (handler.getLogEntries().size() == 0) {
            return;
        }
        BaseDialog dialog = this.getParentDialog() != null ? new BaseDialog(this.getParentDialog(), Dialog.ModalityType.MODELESS) : new BaseDialog(this.getParentFrame(), false);
        dialog.setTitle("Flow execution errors");
        LogEntryViewerPanel panel = new LogEntryViewerPanel();
        panel.display(handler.getLogEntries());
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)panel, "Center");
        dialog.setSize(new Dimension(800, 600));
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    public void cleanUp(boolean destroy) {
        if (this.m_CurrentFlow != null) {
            this.showStatus("Cleaning up");
            try {
                if (destroy) {
                    this.m_CurrentFlow.destroy();
                } else {
                    this.m_CurrentFlow.cleanUp();
                }
                this.showStatus("");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.showStatus("Error cleaning up: " + e);
            }
        }
    }

    protected void close() {
        this.cleanUp(true);
        if (this.getParentFrame() != null) {
            ((JFrame)this.getParentFrame()).setDefaultCloseOperation(2);
        }
        this.closeParent();
    }

    protected void newWindow() {
        FlowRunnerPanel panel = null;
        ChildFrame oldFrame = (ChildFrame)GUIHelper.getParent(this.m_Self, ChildFrame.class);
        if (oldFrame != null) {
            ChildFrame newFrame = oldFrame.getNewWindow();
            newFrame.setVisible(true);
            panel = (FlowRunnerPanel)newFrame.getContentPane().getComponent(0);
        } else {
            ChildWindow oldWindow = (ChildWindow)GUIHelper.getParent(this.m_Self, ChildWindow.class);
            if (oldWindow != null) {
                ChildWindow newWindow = oldWindow.getNewWindow();
                newWindow.setVisible(true);
                panel = (FlowRunnerPanel)newWindow.getContentPane().getComponent(0);
            }
        }
        if (panel != null) {
            panel.setCurrentDirectory(this.getCurrentDirectory());
            panel.update();
        }
    }

    protected void duplicateWindow() {
        FlowRunnerPanel panel = null;
        ChildFrame oldFrame = (ChildFrame)GUIHelper.getParent(this.m_Self, ChildFrame.class);
        if (oldFrame != null) {
            ChildFrame newFrame = oldFrame.getNewWindow();
            newFrame.setVisible(true);
            panel = (FlowRunnerPanel)newFrame.getContentPane().getComponent(0);
        } else {
            ChildWindow oldWindow = (ChildWindow)GUIHelper.getParent(this.m_Self, ChildWindow.class);
            if (oldWindow != null) {
                ChildWindow newWindow = oldWindow.getNewWindow();
                newWindow.setVisible(true);
                panel = (FlowRunnerPanel)newWindow.getContentPane().getComponent(0);
            }
        }
        if (panel != null) {
            panel.setCurrentDirectory(this.getCurrentDirectory());
            panel.setCurrentFlow(this.getCurrentFlow());
            panel.setCurrentFile(this.getCurrentFile());
            panel.update();
        }
    }

    protected void showMessage() {
        if (this.m_StatusBar.hasStatus()) {
            this.showMessage(this.m_StatusBar.getStatus());
        }
    }

    protected void showMessage(String msg) {
        String status = msg.replaceAll(": ", ":\n");
        GUIHelper.showInformationMessage(this, status, "Status");
    }

    @Override
    public void showStatus(String msg) {
        this.m_StatusBar.showStatus(msg);
    }

    public void setCurrentDirectory(File dir) {
        this.m_FileChooser.setCurrentDirectory(dir);
    }

    public File getCurrentDirectory() {
        return this.m_FileChooser.getCurrentDirectory();
    }

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("flow runner panel");
        }
        return m_Properties;
    }
}

