/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tree.menu;

import adams.core.Pausable;
import adams.flow.core.ActorUtils;
import adams.flow.execution.AbstractBreakpoint;
import adams.flow.execution.Debug;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.PathBreakpoint;
import adams.gui.flow.tree.StateContainer;
import adams.gui.flow.tree.menu.AbstractTreePopupMenuItem;
import adams.gui.flow.tree.menu.AbstractTreeShortcut;
import adams.gui.goe.GenericObjectEditorDialog;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;

public class AttachListener
extends AbstractTreePopupMenuItem {
    private static final long serialVersionUID = -1359983192445709718L;

    @Override
    protected JMenuItem getMenuItem(final StateContainer state) {
        JMenuItem result = new JMenuItem("Attach listener...");
        result.setEnabled(this.getShortcut().stateApplies(state));
        result.setAccelerator(this.getShortcut().getKeyStroke());
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttachListener.this.getShortcut().execute(state);
            }
        });
        return result;
    }

    @Override
    protected AbstractTreeShortcut newShortcut() {
        return new AbstractTreeShortcut(){
            private static final long serialVersionUID = -7897333416159785241L;

            @Override
            protected String getTreeShortCutKey() {
                return "AttachListener";
            }

            @Override
            public boolean stateApplies(StateContainer state) {
                return state.numSel == 1 && state.runningFlow != null && state.runningFlow instanceof Pausable && ((Pausable)((Object)state.runningFlow)).isPaused();
            }

            @Override
            protected void doExecute(StateContainer state) {
                PathBreakpoint pbreak = new PathBreakpoint();
                pbreak.setPath(state.selNode.getFullName());
                if (ActorUtils.isSource(state.selNode.getActor())) {
                    pbreak.setOnPostOutput(true);
                }
                if (ActorUtils.isTransformer(state.selNode.getActor())) {
                    pbreak.setOnPreInput(true);
                }
                if (ActorUtils.isSink(state.selNode.getActor())) {
                    pbreak.setOnPreInput(true);
                }
                Debug debug = new Debug();
                debug.setBreakpoints(new AbstractBreakpoint[]{pbreak});
                GenericObjectEditorDialog dialog = state.tree != null && state.tree.getParentDialog() != null ? new GenericObjectEditorDialog(state.tree.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : (state.tree != null && state.tree.getParentFrame() != null ? new GenericObjectEditorDialog(state.tree.getParentFrame(), true) : new GenericObjectEditorDialog((Dialog)null, Dialog.ModalityType.DOCUMENT_MODAL));
                dialog.setTitle("Attach listener [" + state.selNode.getFullName() + "]");
                dialog.getGOEEditor().setClassType(FlowExecutionListener.class);
                dialog.getGOEEditor().setCanChangeClassInDialog(true);
                dialog.setCurrent(debug);
                dialog.setLocationRelativeTo(state.tree);
                dialog.setVisible(true);
                if (dialog.getResult() != 0) {
                    return;
                }
                state.runningFlow.startListeningAtRuntime((FlowExecutionListener)dialog.getCurrent());
            }
        };
    }
}

