/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tree.menu;

import adams.core.Pausable;
import adams.core.ShallowCopySupporter;
import adams.core.Utils;
import adams.flow.execution.FlowExecutionListener;
import adams.gui.flow.tree.StateContainer;
import adams.gui.flow.tree.menu.AbstractTreePopupMenuItem;
import adams.gui.flow.tree.menu.AbstractTreeShortcut;
import adams.gui.goe.GenericObjectEditorDialog;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;

public class EditListeners
extends AbstractTreePopupMenuItem {
    private static final long serialVersionUID = -1359983192445709718L;

    @Override
    protected JMenuItem getMenuItem(final StateContainer state) {
        JMenuItem result = new JMenuItem("Edit listeners...");
        result.setEnabled(this.getShortcut().stateApplies(state));
        result.setAccelerator(this.getShortcut().getKeyStroke());
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditListeners.this.getShortcut().execute(state);
            }
        });
        return result;
    }

    @Override
    protected AbstractTreeShortcut newShortcut() {
        return new AbstractTreeShortcut(){
            private static final long serialVersionUID = -7897333416159785241L;

            @Override
            protected String getTreeShortCutKey() {
                return "EditListeners";
            }

            @Override
            public boolean stateApplies(StateContainer state) {
                return state.runningFlow != null && state.runningFlow instanceof Pausable && ((Pausable)((Object)state.runningFlow)).isPaused();
            }

            @Override
            protected void doExecute(StateContainer state) {
                GenericObjectEditorDialog dialog = state.tree != null && state.tree.getParentDialog() != null ? new GenericObjectEditorDialog(state.tree.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : (state.tree != null && state.tree.getParentFrame() != null ? new GenericObjectEditorDialog(state.tree.getParentFrame(), true) : new GenericObjectEditorDialog((Dialog)null, Dialog.ModalityType.DOCUMENT_MODAL));
                dialog.setTitle("Edit listeners");
                dialog.getGOEEditor().setClassType(FlowExecutionListener.class);
                dialog.getGOEEditor().setCanChangeClassInDialog(true);
                if (state.runningFlow.getFlowExecutionListener() instanceof ShallowCopySupporter) {
                    dialog.setCurrent(((ShallowCopySupporter)((Object)state.runningFlow.getFlowExecutionListener())).shallowCopy());
                } else {
                    dialog.setCurrent(Utils.deepCopy(state.runningFlow.getFlowExecutionListener()));
                }
                dialog.setLocationRelativeTo(state.tree);
                dialog.setVisible(true);
                if (dialog.getResult() != 0) {
                    return;
                }
                state.runningFlow.startListeningAtRuntime((FlowExecutionListener)dialog.getCurrent());
            }
        };
    }
}

