/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tree.menu;

import adams.core.io.FlowFile;
import adams.flow.core.ExternalActorHandler;
import adams.gui.core.GUIHelper;
import adams.gui.flow.tree.StateContainer;
import adams.gui.flow.tree.menu.AbstractTreePopupMenuItem;
import adams.gui.flow.tree.menu.AbstractTreeShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;

public class ExpandCollapseExternalFlow
extends AbstractTreePopupMenuItem {
    private static final long serialVersionUID = 2861368330653134074L;

    @Override
    protected JMenuItem getMenuItem(final StateContainer state) {
        JMenuItem result;
        if (state.selNode != null && state.selNode.getExpansionOccurred()) {
            result = new JMenuItem("Collapse");
            result.setIcon(GUIHelper.getIcon("collapse.png"));
            result.setEnabled(this.getShortcut().stateApplies(state));
            result.setAccelerator(this.getShortcut().getKeyStroke());
            result.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExpandCollapseExternalFlow.this.getShortcut().execute(state);
                }
            });
        } else {
            result = new JMenuItem("Expand");
            result.setIcon(GUIHelper.getIcon("expand.png"));
            result.setEnabled(this.getShortcut().stateApplies(state));
            result.setAccelerator(this.getShortcut().getKeyStroke());
            result.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExpandCollapseExternalFlow.this.getShortcut().execute(state);
                }
            });
        }
        return result;
    }

    @Override
    protected AbstractTreeShortcut newShortcut() {
        return new AbstractTreeShortcut(){
            private static final long serialVersionUID = -7897333416159785241L;

            @Override
            protected String getTreeShortCutKey() {
                return "ExternalFlow.CollapseExpand";
            }

            @Override
            public boolean stateApplies(StateContainer state) {
                boolean result;
                boolean bl = result = state.isSingleSel && state.selNode.getActor() instanceof ExternalActorHandler;
                if (result) {
                    FlowFile file = ((ExternalActorHandler)((Object)state.selNode.getActor())).getActorFile();
                    result = file.exists() && !file.isDirectory();
                }
                return result;
            }

            @Override
            protected void doExecute(StateContainer state) {
                if (state.selNode.getExpansionOccurred()) {
                    state.selNode.collapse();
                } else {
                    state.selNode.expand();
                }
            }
        };
    }
}

