/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.Utils;
import adams.core.base.BaseObject;
import adams.core.base.BaseRegExp;
import adams.core.option.AbstractOption;
import adams.gui.core.BrowserHelper;
import adams.gui.core.GUIHelper;
import adams.gui.goe.BaseObjectEditor;
import adams.gui.goe.MultiLineValueDialog;
import adams.gui.goe.MultiSelectionEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BaseRegExpEditor
extends BaseObjectEditor
implements MultiSelectionEditor {
    protected JCheckBox m_CheckBoxEscapedInput;
    protected JButton m_ButtonHelp;

    public static String toString(AbstractOption option, Object object) {
        return ((BaseRegExp)object).stringValue();
    }

    public static Object valueOf(AbstractOption option, String str) {
        return new BaseRegExp(Utils.unbackQuoteChars(str));
    }

    @Override
    protected JComponent createCustomEditor() {
        JPanel panelAll = new JPanel(new BorderLayout());
        JPanel panel = new JPanel(new FlowLayout(0));
        panelAll.add((Component)panel, "North");
        this.m_TextValue = new JTextField(20);
        this.m_TextValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    BaseRegExpEditor.this.acceptInput();
                } else if (e.getKeyCode() == 27) {
                    e.consume();
                    BaseRegExpEditor.this.discardInput();
                } else {
                    super.keyPressed(e);
                }
            }
        });
        JLabel label = new JLabel("Value");
        label.setDisplayedMnemonic('V');
        label.setLabelFor(this.m_TextValue);
        this.m_ButtonHelp = new JButton(this.getHelpTitle(), GUIHelper.getIcon(this.getHelpIcon()));
        this.m_ButtonHelp.setToolTipText(this.getHelpDescription());
        this.m_ButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserHelper.openURL(BaseRegExpEditor.this.getHelpURL());
            }
        });
        panel.add(label);
        panel.add(this.m_TextValue);
        panel.add(this.m_ButtonHelp);
        JPanel panelCheck = new JPanel(new BorderLayout());
        panelAll.add((Component)panelCheck, "Center");
        panel = new JPanel(new FlowLayout(0));
        panelCheck.add((Component)panel, "North");
        this.m_CheckBoxEscapedInput = new JCheckBox("Escaped input");
        this.m_CheckBoxEscapedInput.setSelected(true);
        this.m_CheckBoxEscapedInput.setMnemonic('E');
        this.m_CheckBoxEscapedInput.setToolTipText("If checked, you can eg enter new lines like '\\n' or tabs like '\\t' (without the quotes)");
        this.m_CheckBoxEscapedInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BaseRegExpEditor.this.m_CheckBoxEscapedInput.isSelected()) {
                    BaseRegExpEditor.this.m_TextValue.setText(Utils.backQuoteChars(BaseRegExpEditor.this.m_TextValue.getText()));
                } else {
                    BaseRegExpEditor.this.m_TextValue.setText(Utils.unbackQuoteChars(BaseRegExpEditor.this.m_TextValue.getText()));
                }
            }
        });
        panelCheck.add(this.m_CheckBoxEscapedInput);
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        panelAll.add((Component)panelButtons, "South");
        JButton buttonOK = new JButton("OK");
        buttonOK.setMnemonic('O');
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseRegExpEditor.this.acceptInput();
            }
        });
        panelButtons.add(buttonOK);
        JButton buttonClose = new JButton("Cancel");
        buttonClose.setMnemonic('C');
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseRegExpEditor.this.discardInput();
            }
        });
        panelButtons.add(buttonClose);
        return panelAll;
    }

    protected String unEscape(String s) {
        if (this.m_CheckBoxEscapedInput.isSelected()) {
            return Utils.unbackQuoteChars(s);
        }
        return s;
    }

    @Override
    protected boolean isValid(String s) {
        return super.isValid(this.unEscape(s));
    }

    @Override
    protected boolean isUnchanged(String s) {
        return super.isUnchanged(this.unEscape(s));
    }

    @Override
    protected BaseObject parse(String s) {
        return super.parse(this.unEscape(s));
    }

    @Override
    protected void initForDisplay() {
        this.resetChosenOption();
        String value = this.m_CheckBoxEscapedInput.isSelected() ? Utils.backQuoteChars(((BaseRegExp)this.getValue()).getValue()) : ((BaseRegExp)this.getValue()).getValue();
        if (!this.m_TextValue.getText().equals(value)) {
            this.m_TextValue.setText(value);
        }
        this.m_TextValue.setToolTipText(((BaseObject)this.getValue()).getTipText());
        this.m_TextValue.grabFocus();
    }

    @Override
    protected String getStringToPaint() {
        return ((BaseRegExp)this.getValue()).stringValue();
    }

    @Override
    public String toCustomStringRepresentation(Object obj) {
        return BaseRegExpEditor.toString(null, obj);
    }

    @Override
    public Object fromCustomStringRepresentation(String str) {
        return BaseRegExpEditor.valueOf(null, str);
    }

    @Override
    public Object[] getSelectedObjects(Container parent) {
        Object[] result;
        MultiLineValueDialog dialog = new MultiLineValueDialog();
        dialog.setInfoText("Enter the regular expressions, one per line:");
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        if (dialog.getOption() == 0) {
            Vector<String> lines = new Vector<String>(Arrays.asList(dialog.getContent().split("\n")));
            Utils.removeEmptyLines(lines);
            result = new BaseRegExp[lines.size()];
            for (int i = 0; i < lines.size(); ++i) {
                result[i] = (BaseRegExp)this.parse(lines.get(i));
            }
        } else {
            result = new BaseRegExp[]{};
        }
        return result;
    }

    @Override
    public String getHelpURL() {
        return "http://docs.oracle.com/javase/6/docs/api/java/util/regex/Pattern.html";
    }

    @Override
    public String getHelpDescription() {
        return "More info on regular expressions";
    }

    @Override
    public String getHelpTitle() {
        return null;
    }

    @Override
    public String getHelpIcon() {
        return "help2.png";
    }
}

