/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.Index;
import adams.core.Utils;
import adams.core.option.AbstractOption;
import adams.gui.core.GUIHelper;
import adams.gui.dialog.TextDialog;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import adams.gui.goe.InlineEditorSupport;
import adams.gui.goe.MultiLineValueDialog;
import adams.gui.goe.MultiSelectionEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class IndexEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler,
MultiSelectionEditor,
InlineEditorSupport {
    protected JTextField m_TextValue;
    protected JButton m_ButtonHelp;
    protected JPanel m_PanelValue;
    protected Color m_DefaultBackground;

    public static String toString(AbstractOption option, Object object) {
        return ((Index)object).getIndex();
    }

    public static Object valueOf(AbstractOption option, String str) {
        return new Index(str);
    }

    @Override
    public String toCustomStringRepresentation(Object obj) {
        return IndexEditor.toString(null, obj);
    }

    @Override
    public Object fromCustomStringRepresentation(String str) {
        return new Index(str);
    }

    @Override
    public String getJavaInitializationString() {
        return "new " + this.getValue().getClass().getName() + "(\"" + this.getValue() + "\")";
    }

    protected String getStringToPaint() {
        return "" + ((Index)this.getValue()).getIndex();
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        String val = this.getStringToPaint();
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }

    protected Index parse(String s) {
        Index result;
        try {
            result = new Index(s, Integer.MAX_VALUE);
            if (result.getIntIndex() == -1) {
                result = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    @Override
    protected JComponent createCustomEditor() {
        JPanel panelAll = new JPanel(new BorderLayout());
        this.m_PanelValue = new JPanel(new FlowLayout(0));
        this.m_DefaultBackground = this.m_PanelValue.getBackground();
        this.m_PanelValue.setBorder(BorderFactory.createLineBorder(this.m_DefaultBackground));
        panelAll.add((Component)this.m_PanelValue, "Center");
        this.m_TextValue = new JTextField(10);
        this.m_TextValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    IndexEditor.this.acceptInput();
                } else if (e.getKeyCode() == 27) {
                    e.consume();
                    IndexEditor.this.discardInput();
                } else {
                    super.keyPressed(e);
                }
            }
        });
        this.m_TextValue.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                IndexEditor.this.indicateValidity();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                IndexEditor.this.indicateValidity();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                IndexEditor.this.indicateValidity();
            }
        });
        this.m_ButtonHelp = new JButton();
        this.m_ButtonHelp.setVisible(false);
        this.m_ButtonHelp.setToolTipText(this.getHelpDescription());
        this.m_ButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextDialog dlg = new TextDialog();
                dlg.setDefaultCloseOperation(2);
                dlg.setDialogTitle("Help");
                dlg.setContent(IndexEditor.this.getHelpDescription());
                dlg.setSize(400, 400);
                dlg.setLocationRelativeTo(IndexEditor.this.m_ButtonHelp);
                dlg.setLineWrap(true);
                dlg.setEditable(false);
                dlg.setVisible(true);
            }
        });
        JLabel label = new JLabel("Index");
        label.setDisplayedMnemonic('I');
        label.setLabelFor(this.m_TextValue);
        this.m_PanelValue.add(label);
        this.m_PanelValue.add(this.m_TextValue);
        this.m_PanelValue.add(this.m_ButtonHelp);
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        panelAll.add((Component)panelButtons, "South");
        JButton buttonOK = new JButton("OK");
        buttonOK.setMnemonic('O');
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndexEditor.this.acceptInput();
            }
        });
        panelButtons.add(buttonOK);
        JButton buttonClose = new JButton("Cancel");
        buttonClose.setMnemonic('C');
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndexEditor.this.discardInput();
            }
        });
        panelButtons.add(buttonClose);
        return panelAll;
    }

    protected boolean isValid(String s) {
        return this.parse(s) != null;
    }

    protected boolean isUnchanged(String s) {
        return s.equals(((Index)this.getValue()).getIndex());
    }

    protected void acceptInput() {
        String s = this.m_TextValue.getText();
        if (this.isValid(s) && !this.isUnchanged(s)) {
            this.setValue(this.parse(s));
        }
        this.closeDialog(1);
    }

    protected void discardInput() {
        this.closeDialog(0);
    }

    @Override
    protected void initForDisplay() {
        super.initForDisplay();
        String current = ((Index)this.getValue()).getIndex();
        if (!this.m_TextValue.getText().equals(current)) {
            this.m_TextValue.setText(current);
        }
        this.m_TextValue.setToolTipText(((Index)this.getValue()).getExample());
        this.m_TextValue.grabFocus();
        if (this.m_ButtonHelp != null) {
            this.m_ButtonHelp.setVisible(this.getHelpDescription() != null);
            this.m_ButtonHelp.setToolTipText(this.getHelpDescription());
            if (this.getHelpIcon() != null) {
                this.m_ButtonHelp.setIcon(GUIHelper.getIcon(this.getHelpIcon()));
            } else {
                this.m_ButtonHelp.setIcon(null);
            }
            this.m_ButtonHelp.setText(this.getHelpTitle());
        }
    }

    @Override
    public Object[] getSelectedObjects(Container parent) {
        Object[] result;
        MultiLineValueDialog dialog = new MultiLineValueDialog();
        dialog.setInfoText("Enter the indices, one per line:");
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        if (dialog.getOption() == 0) {
            Vector<String> lines = new Vector<String>(Arrays.asList(dialog.getContent().split("\n")));
            Utils.removeEmptyLines(lines);
            result = new Index[lines.size()];
            for (int i = 0; i < lines.size(); ++i) {
                result[i] = this.parse(lines.get(i));
            }
        } else {
            result = new Index[]{};
        }
        return result;
    }

    @Override
    public boolean isInlineEditingAvailable() {
        return true;
    }

    @Override
    public void setInlineValue(String value) {
        if (this.isValid(value)) {
            this.setValue(this.parse(value));
        }
    }

    @Override
    public String getInlineValue() {
        return ((Index)this.getValue()).getIndex();
    }

    @Override
    public boolean isInlineValueValid(String value) {
        return this.isValid(value);
    }

    protected void indicateValidity() {
        Color curColor = ((LineBorder)this.m_PanelValue.getBorder()).getLineColor();
        Color newColor = this.isValid(this.m_TextValue.getText()) ? this.m_DefaultBackground : Color.RED;
        if (!newColor.equals(curColor)) {
            this.m_PanelValue.setBorder(BorderFactory.createLineBorder(newColor));
        }
    }
}

