/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.Utils;
import adams.gui.core.TextEditorPanel;
import adams.gui.dialog.ApprovalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MultiLineValueDialog
extends ApprovalDialog {
    private static final long serialVersionUID = -3749635663753848815L;
    protected JPanel m_PanelAll;
    protected JPanel m_PanelInfo;
    protected JPanel m_PanelBottom;
    protected JLabel m_LabelInfo;
    protected String m_PrefixCount;
    protected JLabel m_LabelCount;
    protected TextEditorPanel m_Editor;

    public MultiLineValueDialog() {
        super((Frame)null);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_PrefixCount = "Value count: ";
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_Editor = new TextEditorPanel();
        this.m_Editor.getTextArea().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                MultiLineValueDialog.this.updateCount();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                MultiLineValueDialog.this.updateCount();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                MultiLineValueDialog.this.updateCount();
            }
        });
        this.m_LabelInfo = new JLabel("Enter the values, one per line:");
        this.m_PanelInfo = new JPanel(new FlowLayout(0));
        this.m_PanelInfo.add(this.m_LabelInfo);
        this.m_PanelBottom = new JPanel(new BorderLayout());
        this.m_PanelBottom.setVisible(true);
        JPanel panel = new JPanel(new FlowLayout(0));
        this.m_PanelBottom.add((Component)panel, "South");
        this.m_LabelCount = new JLabel("");
        panel.add(this.m_LabelCount);
        this.m_PanelAll = new JPanel(new BorderLayout());
        this.m_PanelAll.add((Component)this.m_PanelInfo, "North");
        this.m_PanelAll.add((Component)this.m_Editor, "Center");
        this.m_PanelAll.add((Component)this.m_PanelBottom, "South");
        this.getContentPane().add((Component)this.m_PanelAll, "Center");
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setSize(400, 300);
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        this.updateCount();
    }

    protected void updateCount() {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(this.m_Editor.getTextArea().getText().split("\n")));
        Utils.removeEmptyLines(list, true);
        String text = this.m_PrefixCount + list.size();
        this.m_LabelCount.setText(text);
    }

    public void setInfoText(String value) {
        this.m_LabelInfo.setText(value);
    }

    public String getInfoText() {
        return this.m_LabelInfo.getText();
    }

    public JPanel getBottomPanel() {
        return this.m_PanelBottom;
    }

    public void setPrefixCount(String value) {
        this.m_PrefixCount = value;
        this.updateCount();
    }

    public String getPrefixCount() {
        return this.m_PrefixCount;
    }

    public void setContent(String value) {
        this.m_Editor.setContent(value);
    }

    public String getContent() {
        return this.m_Editor.getContent();
    }
}

