/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe.classtree;

import adams.gui.core.dotnotationtree.DotNotationNode;

public class ClassNode
extends DotNotationNode {
    private static final long serialVersionUID = 9062259637831548370L;
    protected Boolean m_Deprecated;

    public ClassNode(String label) {
        super(label);
    }

    @Override
    public boolean isItemLeaf() {
        boolean result = true;
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (!(this.getChildAt(i) instanceof ClassNode)) continue;
            result = false;
            break;
        }
        return result;
    }

    public synchronized boolean isDeprecated() {
        if (this.m_Deprecated == null) {
            if (this.isItemLeaf()) {
                try {
                    Class<?> cls = Class.forName(this.getItem());
                    this.m_Deprecated = cls.getAnnotation(Deprecated.class) != null;
                }
                catch (Exception e) {
                    this.m_Deprecated = false;
                }
            } else {
                this.m_Deprecated = false;
            }
        }
        return this.m_Deprecated;
    }

    @Override
    public String toString() {
        if (this.isDeprecated()) {
            return "<html><strike>" + super.toString() + "</strike></html>";
        }
        return super.toString();
    }
}

