/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.scripting;

import adams.core.option.OptionUtils;
import adams.gui.scripting.AbstractDataContainerPanelScriptlet;
import adams.gui.visualization.container.AbstractContainer;
import adams.gui.visualization.container.AbstractContainerManager;
import adams.gui.visualization.container.NamedContainer;

public class SetData
extends AbstractDataContainerPanelScriptlet {
    private static final long serialVersionUID = -5936800338572570006L;
    public static final String ACTION = "set-data";

    @Override
    public String getAction() {
        return ACTION;
    }

    @Override
    protected String getOptionsDescription() {
        return "<index> <DB-ID>";
    }

    @Override
    public String getDescription() {
        return "Replaces the currently loaded data container at the specified 1-based index with the one associated with the database ID.";
    }

    @Override
    public String process(String options) throws Exception {
        String[] list = OptionUtils.splitOptions(options);
        int index = Integer.parseInt(list[0]) - 1;
        int id = new Integer(list[1]);
        this.addUndoPoint("Saving undo data...", "Set data at " + (index + 1) + ": " + id);
        this.showStatus("Loading the data...");
        Object data = this.m_DataProvider.load(id);
        Object manager = this.getDataContainerPanel().getContainerManager();
        this.showStatus("Setting the data...");
        if (data != null) {
            Object cont = ((AbstractContainerManager)manager).get(index);
            Object contNew = ((AbstractContainerManager)manager).newContainer((Comparable)data);
            String idNew = null;
            if (contNew instanceof NamedContainer) {
                idNew = ((NamedContainer)contNew).getID();
            }
            ((AbstractContainer)contNew).assign((AbstractContainer)cont);
            ((AbstractContainer)contNew).setPayload((Comparable)data);
            if (contNew instanceof NamedContainer) {
                ((NamedContainer)contNew).setID(idNew);
            }
            ((AbstractContainerManager)manager).set(index, contNew);
        }
        this.showStatus("");
        return null;
    }
}

