/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.gui.chooser.FileChooserPanel;
import adams.gui.core.BasePanel;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.ParameterPanel;
import adams.gui.core.RecentFilesHandler;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.event.RecentItemEvent;
import adams.gui.event.RecentItemListener;
import adams.gui.visualization.debug.SideBySideDiffPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DiffPanel
extends BasePanel
implements MenuBarProvider {
    private static final long serialVersionUID = 1623023054538026169L;
    public static final String SESSION_FILE_LEFT = "DiffLeft.props";
    public static final String SESSION_FILE_RIGHT = "DiffRight.props";
    protected SideBySideDiffPanel m_PanelDiff;
    protected ArrayList<String> m_ClipboardLeft;
    protected ArrayList<String> m_ClipboardRight;
    protected File m_FileLeft;
    protected File m_FileRight;
    protected JMenuBar m_MenuBar;
    protected JMenu m_MenuFileLoadRecentLeft;
    protected JMenu m_MenuFileLoadRecentRight;
    protected JMenuItem m_MenuItemEditPasteLeft;
    protected JMenuItem m_MenuItemEditPasteRight;
    protected LoadDialog m_LoadDialog;
    protected JButton m_ButtonPasteLeft;
    protected JButton m_ButtonPasteRight;
    protected RecentFilesHandler<JMenu> m_RecentFilesHandlerLeft;
    protected RecentFilesHandler<JMenu> m_RecentFilesHandlerRight;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_ClipboardLeft = null;
        this.m_ClipboardRight = null;
        this.m_FileLeft = new PlaceholderFile(".");
        this.m_FileRight = new PlaceholderFile(".");
        this.m_RecentFilesHandlerLeft = null;
        this.m_RecentFilesHandlerRight = null;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PanelDiff = new SideBySideDiffPanel();
        this.add((Component)this.m_PanelDiff, "Center");
        this.m_ButtonPasteLeft = new JButton(GUIHelper.getIcon("paste.gif"));
        this.m_ButtonPasteLeft.setToolTipText("Paste from clipboard");
        this.m_ButtonPasteLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiffPanel.this.pasteLeft();
            }
        });
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(this.m_ButtonPasteLeft);
        this.m_PanelDiff.getPanel(true).add((Component)panel, "South");
        this.m_ButtonPasteRight = new JButton(GUIHelper.getIcon("paste.gif"));
        this.m_ButtonPasteRight.setToolTipText("Paste from clipboard");
        this.m_ButtonPasteRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiffPanel.this.pasteRight();
            }
        });
        panel = new JPanel(new FlowLayout(2));
        panel.add(this.m_ButtonPasteRight);
        this.m_PanelDiff.getPanel(false).add((Component)panel, "South");
    }

    @Override
    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DiffPanel.this.updateMenu();
                }
            });
            JMenuItem menuitem = new JMenuItem("Open files...");
            menu.add(menuitem);
            menuitem.setMnemonic('O');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed O"));
            menuitem.setIcon(GUIHelper.getIcon("open.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DiffPanel.this.openFiles();
                }
            });
            JMenu submenu = new JMenu("Open recent (left)");
            menu.add(submenu);
            this.m_RecentFilesHandlerLeft = new RecentFilesHandler<JMenu>(SESSION_FILE_LEFT, 5, submenu);
            this.m_RecentFilesHandlerLeft.addRecentItemListener(new RecentItemListener<JMenu, File>(){

                @Override
                public void recentItemAdded(RecentItemEvent<JMenu, File> e) {
                }

                @Override
                public void recentItemSelected(RecentItemEvent<JMenu, File> e) {
                    DiffPanel.this.m_FileLeft = new PlaceholderFile(e.getItem());
                    DiffPanel.this.m_ClipboardLeft = null;
                    DiffPanel.this.m_RecentFilesHandlerLeft.addRecentItem(DiffPanel.this.m_FileLeft);
                    DiffPanel.this.compare();
                }
            });
            this.m_MenuFileLoadRecentLeft = submenu;
            submenu = new JMenu("Open recent (right)");
            menu.add(submenu);
            this.m_RecentFilesHandlerRight = new RecentFilesHandler<JMenu>(SESSION_FILE_RIGHT, 5, submenu);
            this.m_RecentFilesHandlerRight.addRecentItemListener(new RecentItemListener<JMenu, File>(){

                @Override
                public void recentItemAdded(RecentItemEvent<JMenu, File> e) {
                }

                @Override
                public void recentItemSelected(RecentItemEvent<JMenu, File> e) {
                    DiffPanel.this.m_FileRight = new PlaceholderFile(e.getItem());
                    DiffPanel.this.m_ClipboardRight = null;
                    DiffPanel.this.m_RecentFilesHandlerRight.addRecentItem(DiffPanel.this.m_FileRight);
                    DiffPanel.this.compare();
                }
            });
            this.m_MenuFileLoadRecentRight = submenu;
            menuitem = new JMenuItem("Reload");
            menu.add(menuitem);
            menuitem.setMnemonic('R');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("F5"));
            menuitem.setIcon(GUIHelper.getIcon("refresh.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DiffPanel.this.reload();
                }
            });
            menuitem = new JMenuItem("Close");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed Q"));
            menuitem.setIcon(GUIHelper.getIcon("exit.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DiffPanel.this.closeParent();
                }
            });
            menu = new JMenu("Edit");
            result.add(menu);
            menu.setMnemonic('E');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DiffPanel.this.updateMenu();
                }
            });
            menuitem = new JMenuItem("Paste (left)");
            menu.add(menuitem);
            menuitem.setMnemonic('l');
            menuitem.setIcon(GUIHelper.getIcon("paste.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DiffPanel.this.pasteLeft();
                }
            });
            this.m_MenuItemEditPasteLeft = menuitem;
            menuitem = new JMenuItem("Paste (right)");
            menu.add(menuitem);
            menuitem.setMnemonic('r');
            menuitem.setIcon(GUIHelper.getIcon("paste.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DiffPanel.this.pasteRight();
                }
            });
            this.m_MenuItemEditPasteRight = menuitem;
            this.m_MenuBar = result;
            this.updateMenu();
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        this.m_MenuFileLoadRecentLeft.setEnabled(this.m_RecentFilesHandlerLeft.size() > 0);
        this.m_MenuFileLoadRecentRight.setEnabled(this.m_RecentFilesHandlerRight.size() > 0);
        this.m_MenuItemEditPasteLeft.setEnabled(GUIHelper.canPasteStringFromClipboard());
        this.m_MenuItemEditPasteRight.setEnabled(GUIHelper.canPasteStringFromClipboard());
    }

    protected void pasteLeft() {
        if (!GUIHelper.canPasteStringFromClipboard()) {
            return;
        }
        this.m_ClipboardLeft = new ArrayList<String>(Arrays.asList(GUIHelper.pasteStringFromClipboard().split("\n")));
        this.compare();
    }

    protected void pasteRight() {
        if (!GUIHelper.canPasteStringFromClipboard()) {
            return;
        }
        this.m_ClipboardRight = new ArrayList<String>(Arrays.asList(GUIHelper.pasteStringFromClipboard().split("\n")));
        this.compare();
    }

    protected void openFiles() {
        if (this.m_LoadDialog == null) {
            this.m_LoadDialog = this.getParentDialog() != null ? new LoadDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new LoadDialog(this.getParentFrame(), true);
            this.m_LoadDialog.setLocationRelativeTo(this);
        }
        this.m_LoadDialog.setVisible(true);
        if (this.m_LoadDialog.getOption() != 0) {
            return;
        }
        this.m_ClipboardLeft = null;
        this.m_ClipboardRight = null;
        this.m_FileLeft = this.m_LoadDialog.getFirstFile();
        this.m_FileRight = this.m_LoadDialog.getSecondFile();
        this.m_RecentFilesHandlerLeft.addRecentItem(this.m_FileLeft);
        this.m_RecentFilesHandlerRight.addRecentItem(this.m_FileRight);
        this.compare();
    }

    public void compareFiles(File file1, File file2) {
        if (!file1.exists() || file1.isDirectory()) {
            System.err.println("File 1 '" + file1 + "' does not exist or is a directory!");
            return;
        }
        if (!file2.exists() || file2.isDirectory()) {
            System.err.println("File 2 '" + file2 + "' does not exist or is a directory!");
            return;
        }
        this.m_FileLeft = file1;
        this.m_FileRight = file2;
        this.m_RecentFilesHandlerLeft.addRecentItem(this.m_FileLeft);
        this.m_RecentFilesHandlerRight.addRecentItem(this.m_FileRight);
        this.compare();
    }

    protected void reload() {
        this.compare();
    }

    protected void compare() {
        List<String> right;
        List<String> left;
        if (this.m_ClipboardLeft != null) {
            left = this.m_ClipboardLeft;
            this.m_PanelDiff.setLabelText(true, "Clipboard");
        } else {
            left = this.m_FileLeft.isDirectory() ? new ArrayList() : FileUtils.loadFromFile(this.m_FileLeft);
            this.m_PanelDiff.setLabelText(true, this.m_FileLeft.toString());
        }
        if (this.m_ClipboardRight != null) {
            right = this.m_ClipboardRight;
            this.m_PanelDiff.setLabelText(false, "Clipboard");
        } else {
            right = this.m_FileRight.isDirectory() ? new ArrayList() : FileUtils.loadFromFile(this.m_FileRight);
            this.m_PanelDiff.setLabelText(false, this.m_FileRight.toString());
        }
        this.m_PanelDiff.compare(left, right);
    }

    public static class LoadDialog
    extends ApprovalDialog {
        private static final long serialVersionUID = 4178028433029613223L;
        protected ParameterPanel m_PanelFiles;
        protected FileChooserPanel m_PanelFile1;
        protected FileChooserPanel m_PanelFile2;

        public LoadDialog(Dialog owner) {
            super(owner);
        }

        public LoadDialog(Dialog owner, Dialog.ModalityType modality) {
            super(owner, modality);
        }

        public LoadDialog(Dialog owner, String title) {
            super(owner, title);
        }

        public LoadDialog(Frame owner) {
            super(owner);
        }

        public LoadDialog(Frame owner, boolean modal) {
            super(owner, modal);
        }

        @Override
        protected void initGUI() {
            super.initGUI();
            this.setTitle("Load files to compare");
            this.m_PanelFiles = new ParameterPanel();
            this.getContentPane().add((Component)this.m_PanelFiles, "Center");
            this.m_PanelFile1 = new FileChooserPanel();
            this.m_PanelFile1.setPrefix("First file");
            this.m_PanelFile1.setAcceptAllFileFilterUsed(true);
            this.m_PanelFile1.addChoosableFileFilter(ExtensionFileFilter.getFlowFileFilter());
            this.m_PanelFile1.addChoosableFileFilter(ExtensionFileFilter.getPropertiesFileFilter());
            this.m_PanelFile1.addChoosableFileFilter(ExtensionFileFilter.getTextFileFilter());
            this.m_PanelFiles.addParameter(this.m_PanelFile1);
            this.m_PanelFile2 = new FileChooserPanel();
            this.m_PanelFile2.setPrefix("Second file");
            this.m_PanelFile2.setAcceptAllFileFilterUsed(true);
            this.m_PanelFile2.addChoosableFileFilter(ExtensionFileFilter.getFlowFileFilter());
            this.m_PanelFile2.addChoosableFileFilter(ExtensionFileFilter.getPropertiesFileFilter());
            this.m_PanelFile2.addChoosableFileFilter(ExtensionFileFilter.getTextFileFilter());
            this.m_PanelFiles.addParameter(this.m_PanelFile2);
            this.pack();
        }

        @Override
        protected String checkInput() {
            if (((File)this.m_PanelFile1.getCurrent()).isDirectory()) {
                return "First file is a directory!";
            }
            if (!((File)this.m_PanelFile1.getCurrent()).exists()) {
                return "First file does not exist!";
            }
            if (((File)this.m_PanelFile2.getCurrent()).isDirectory()) {
                return "Second file is a directory!";
            }
            if (!((File)this.m_PanelFile2.getCurrent()).exists()) {
                return "Second file does not exist!";
            }
            return null;
        }

        public File getFirstFile() {
            return (File)this.m_PanelFile1.getCurrent();
        }

        public File getSecondFile() {
            return (File)this.m_PanelFile2.getCurrent();
        }
    }
}

