/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.Properties;
import adams.core.io.PlaceholderDirectory;
import adams.gui.chooser.DirectoryChooserPanel;
import adams.gui.chooser.FileChooserBookmark;
import adams.gui.chooser.FileChooserBookmarksManger;
import adams.gui.core.GUIHelper;
import adams.gui.core.ParameterPanelWithButtons;
import adams.gui.core.SearchParameters;
import adams.gui.tools.AbstractManagementPanelWithProperties;
import adams.gui.tools.AbstractManagementTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JTextField;

public class FileChooserBookmarksManagementPanel
extends AbstractManagementPanelWithProperties<FileChooserBookmark> {
    private static final long serialVersionUID = 2870352856009767535L;
    protected JTextField m_TextName;
    protected DirectoryChooserPanel m_PanelDirectory;
    protected JButton m_ButtonUp;
    protected JButton m_ButtonDown;

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_ButtonUp = new JButton(GUIHelper.getIcon("arrow_up.gif"));
        this.m_ButtonUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = FileChooserBookmarksManagementPanel.this.m_TableValues.getSelectedRow();
                if (index == -1) {
                    return;
                }
                if (FileChooserBookmarksManagementPanel.this.m_ModelValues.moveUp(index)) {
                    FileChooserBookmarksManagementPanel.this.storeProperties();
                    FileChooserBookmarksManagementPanel.this.m_TableValues.getSelectionModel().setSelectionInterval(index - 1, index - 1);
                }
            }
        });
        this.m_TableValues.addToButtonsPanel(this.m_ButtonUp);
        this.m_ButtonDown = new JButton(GUIHelper.getIcon("arrow_down.gif"));
        this.m_ButtonDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = FileChooserBookmarksManagementPanel.this.m_TableValues.getSelectedRow();
                if (index == -1) {
                    return;
                }
                if (FileChooserBookmarksManagementPanel.this.m_ModelValues.moveDown(index)) {
                    FileChooserBookmarksManagementPanel.this.storeProperties();
                    FileChooserBookmarksManagementPanel.this.m_TableValues.getSelectionModel().setSelectionInterval(index + 1, index + 1);
                }
            }
        });
        this.m_TableValues.addToButtonsPanel(this.m_ButtonDown);
    }

    @Override
    protected void addFields(ParameterPanelWithButtons panel) {
        this.m_TextName = new JTextField(30);
        this.addListener(this.m_TextName);
        panel.addParameter("_Name", this.m_TextName);
        this.m_PanelDirectory = new DirectoryChooserPanel();
        this.addListener(this.m_PanelDirectory);
        panel.addParameter("_Directory", (Component)this.m_PanelDirectory);
    }

    @Override
    protected synchronized Properties getProperties() {
        return FileChooserBookmarksManger.getSingleton().getProperties();
    }

    @Override
    protected boolean storeProperties() {
        return FileChooserBookmarksManger.getSingleton().save(this.m_ModelValues.toList());
    }

    @Override
    protected List<FileChooserBookmark> loadAll() {
        return FileChooserBookmarksManger.getSingleton().load();
    }

    @Override
    protected boolean store(FileChooserBookmark value) {
        this.m_ModelValues.add(value);
        return this.storeProperties();
    }

    @Override
    protected boolean remove(FileChooserBookmark value) {
        this.m_ModelValues.remove(value);
        return this.storeProperties();
    }

    @Override
    protected String createKey(FileChooserBookmark value) {
        return value.getName();
    }

    @Override
    protected FileChooserBookmark fromString(String s) {
        return null;
    }

    @Override
    protected String toString(FileChooserBookmark value) {
        return value.getName();
    }

    @Override
    protected AbstractManagementTableModel<FileChooserBookmark> newTableModel() {
        return new TableModel();
    }

    @Override
    protected Class getManagedClass() {
        return FileChooserBookmark.class;
    }

    @Override
    protected void clear() {
        this.m_TextName.setText("");
        this.m_PanelDirectory.setCurrent(new PlaceholderDirectory("."));
    }

    @Override
    protected FileChooserBookmark fieldsToObject() {
        return new FileChooserBookmark(this.m_TextName.getText().trim(), new PlaceholderDirectory((File)this.m_PanelDirectory.getCurrent()));
    }

    @Override
    protected void objectToFields(FileChooserBookmark value) {
        this.m_TextName.setText(value.getName());
        this.m_PanelDirectory.setCurrent(value.getDirectory());
    }

    @Override
    protected boolean canClearFields() {
        return this.m_TextName.getText().length() > 0;
    }

    @Override
    protected boolean isReadOnly() {
        return false;
    }

    @Override
    protected boolean canAddObject() {
        return this.m_TextName.getText().trim().length() > 0;
    }

    @Override
    protected void update() {
        super.update();
        this.m_ButtonUp.setEnabled(this.m_TableValues.getSelectedRowCount() == 1 && this.m_TableValues.getSelectedRow() > 0);
        this.m_ButtonDown.setEnabled(this.m_TableValues.getSelectedRowCount() == 1 && this.m_TableValues.getSelectedRow() < this.m_TableValues.getRowCount() - 1);
    }

    public static class TableModel
    extends AbstractManagementTableModel<FileChooserBookmark> {
        private static final long serialVersionUID = 6097860917524908958L;

        public TableModel() {
            super(false);
        }

        public TableModel(List<FileChooserBookmark> bookmarks) {
            super(bookmarks, false);
        }

        public TableModel(FileChooserBookmark[] bookmarks) {
            super((Comparable[])bookmarks, false);
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Name";
            }
            if (column == 1) {
                return "Directory";
            }
            throw new IllegalArgumentException("Column " + column + " is invalid!");
        }

        @Override
        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return String.class;
            }
            if (columnIndex == 1) {
                return String.class;
            }
            throw new IllegalArgumentException("Column " + columnIndex + " is invalid!");
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return ((FileChooserBookmark)this.m_Values.get(row)).getName();
            }
            if (column == 1) {
                return ((FileChooserBookmark)this.m_Values.get(row)).getDirectory().toString();
            }
            throw new IllegalArgumentException("Column " + column + " is invalid!");
        }

        @Override
        public boolean isSearchMatch(SearchParameters params, int row) {
            if (params.matches(((FileChooserBookmark)this.m_Values.get(row)).getName())) {
                return true;
            }
            return params.matches(((FileChooserBookmark)this.m_Values.get(row)).getDirectory().toString());
        }
    }
}

