/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.ClassLister;
import adams.core.NamedSetup;
import adams.core.NamedSetups;
import adams.core.Properties;
import adams.core.option.OptionUtils;
import adams.env.Environment;
import adams.gui.core.AbstractBaseTableModel;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseTableWithButtons;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.goe.GenericObjectEditorDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class NamedSetupManagementPanel
extends BasePanel
implements MenuBarProvider {
    private static final long serialVersionUID = -1320023079138581818L;
    protected BaseTableWithButtons m_Table;
    protected Model m_Model;
    protected JButton m_ButtonAdd;
    protected JButton m_ButtonRemove;
    protected JMenuBar m_MenuBar;
    protected JMenuItem m_MenuItemSave;
    protected JMenuItem m_MenuItemClose;

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_Model = new Model();
        this.m_Table = new BaseTableWithButtons(this.m_Model);
        this.m_Table.setInfoVisible(true);
        this.m_Table.setAutoResizeMode(0);
        this.m_Table.setOptimalColumnWidth();
        this.m_Table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                NamedSetupManagementPanel.this.updateButtons();
            }
        });
        this.m_Table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                NamedSetupManagementPanel.this.m_Table.setOptimalColumnWidth();
            }
        });
        this.add((Component)this.m_Table, "Center");
        this.m_ButtonAdd = new JButton("Add...");
        this.m_ButtonAdd.setMnemonic('A');
        this.m_ButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NamedSetupManagementPanel.this.add();
            }
        });
        this.m_Table.addToButtonsPanel(this.m_ButtonAdd);
        this.m_ButtonRemove = new JButton("Remove");
        this.m_ButtonRemove.setMnemonic('R');
        this.m_ButtonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NamedSetupManagementPanel.this.remove();
                int[] indices = NamedSetupManagementPanel.this.m_Table.getSelectedRows();
                for (int i = indices.length - 1; i >= 0; --i) {
                    NamedSetupManagementPanel.this.m_Model.remove(indices[i]);
                }
            }
        });
        this.m_Table.addToButtonsPanel(this.m_ButtonRemove);
        this.update();
    }

    @Override
    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            if (this.getParentFrame() != null) {
                JFrame frame = (JFrame)this.getParentFrame();
                frame.setDefaultCloseOperation(0);
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        NamedSetupManagementPanel.this.close();
                    }
                });
            } else if (this.getParentDialog() != null) {
                JDialog dialog = (JDialog)this.getParentDialog();
                dialog.setDefaultCloseOperation(0);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        NamedSetupManagementPanel.this.close();
                    }
                });
            }
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    NamedSetupManagementPanel.this.updateMenu();
                }
            });
            JMenuItem menuitem = new JMenuItem("Save");
            menu.add(menuitem);
            menuitem.setMnemonic('S');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed S"));
            menuitem.setIcon(GUIHelper.getIcon("save.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NamedSetupManagementPanel.this.save();
                }
            });
            this.m_MenuItemSave = menuitem;
            menuitem = new JMenuItem("Close");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed Q"));
            menuitem.setIcon(GUIHelper.getIcon("exit.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NamedSetupManagementPanel.this.close();
                }
            });
            this.m_MenuItemClose = menuitem;
            this.m_MenuBar = result;
            this.updateMenu();
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    protected void updateTitle() {
        String title = "Named setup management";
        if (this.m_Model.isModified()) {
            title = "*" + title;
        }
        this.setParentTitle(title);
    }

    protected void updateMenu() {
        this.updateTitle();
        if (this.m_MenuBar == null) {
            return;
        }
        this.m_MenuItemSave.setEnabled(this.m_Model.isModified());
        this.m_MenuItemClose.setEnabled(true);
    }

    protected void updateButtons() {
        this.m_ButtonAdd.setEnabled(true);
        this.m_ButtonRemove.setEnabled(this.m_Table.getSelectedRowCount() > 0);
    }

    protected void update() {
        this.updateMenu();
        this.updateTitle();
        this.updateButtons();
    }

    protected boolean checkForModified() {
        boolean result;
        boolean bl = result = !this.m_Model.isModified();
        if (!result) {
            int retVal = GUIHelper.showConfirmMessage(this, "Placeholders are modified - save?", "Placeholders modified");
            switch (retVal) {
                case 0: {
                    this.save();
                    result = !this.m_Model.isModified();
                    break;
                }
                case 1: {
                    result = true;
                    break;
                }
                case 2: {
                    result = false;
                }
            }
        }
        return result;
    }

    protected void add() {
        Object defValue;
        Class<?> cls;
        Vector<String> superclasses = new Vector<String>();
        Enumeration<?> enm = ClassLister.getSingleton().getClasses().propertyNames();
        while (enm.hasMoreElements()) {
            superclasses.add(enm.nextElement().toString());
        }
        Collections.sort(superclasses);
        String selected = (String)JOptionPane.showInputDialog(this, "Please select type of setup", "Type", -1, null, superclasses.toArray(new String[superclasses.size()]), null);
        if (selected == null) {
            return;
        }
        try {
            cls = Class.forName(selected);
        }
        catch (Exception e) {
            System.err.println("Failed to obtain class for: " + selected);
            e.printStackTrace();
            return;
        }
        String[] classes = ClassLister.getSingleton().getClassnames(cls);
        if (classes.length == 0) {
            GUIHelper.showErrorMessage(this, "No concrete classes available for superclass '" + cls.getName() + "'!");
            return;
        }
        try {
            defValue = Class.forName(classes[0]).newInstance();
        }
        catch (Exception e) {
            System.err.println("Failed to instantiate object for class  '" + classes[0] + "'!");
            e.printStackTrace();
            return;
        }
        GenericObjectEditorDialog dialog = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog()) : new GenericObjectEditorDialog(this.getParentFrame());
        dialog.getGOEEditor().setCanChangeClassInDialog(true);
        dialog.getGOEEditor().setClassType(cls);
        dialog.getGOEEditor().setValue(defValue);
        dialog.setTitle("Configure the setup");
        dialog.setLocationRelativeTo(this);
        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        dialog.setVisible(true);
        if (dialog.getResult() != 0) {
            return;
        }
        String name = JOptionPane.showInputDialog(GUIHelper.getParentComponent(this), "Please enter 'nickname' for the setup:", "name_for_setup");
        if (name == null) {
            return;
        }
        this.m_Model.add(name, dialog.getCurrent());
        this.update();
    }

    protected void remove() {
        int[] indices = this.m_Table.getSelectedRows();
        for (int i = indices.length - 1; i >= 0; --i) {
            this.m_Model.remove(indices[i]);
        }
        this.update();
    }

    protected void save() {
        String filename = Environment.getInstance().getCustomPropertiesFilename("named setups");
        if (!Environment.getInstance().write("named setups", this.m_Model.getProperties())) {
            GUIHelper.showErrorMessage(this, "Error saving named setups to '" + filename + "'!", "Error saving named setups");
        } else {
            GUIHelper.showInformationMessage(this, "Named setups have been successfully saved to '" + filename + "'!", "Named setups saved");
            NamedSetups.getSingleton().reload();
            this.m_Model = new Model();
            this.m_Table.setModel(this.m_Model);
        }
        this.update();
    }

    protected void close() {
        if (!this.checkForModified()) {
            if (this.getParentDialog() != null) {
                this.getParentDialog().setVisible(true);
            } else if (this.getParentFrame() != null) {
                this.getParentFrame().setVisible(true);
            }
            return;
        }
        if (this.getParentFrame() != null) {
            ((JFrame)this.getParentFrame()).setDefaultCloseOperation(2);
        }
        this.closeParent();
    }

    public static class Model
    extends AbstractBaseTableModel {
        private static final long serialVersionUID = -172967388530743539L;
        protected Vector<String> m_Names = new Vector();
        protected Hashtable<String, String> m_Setups = new Hashtable();
        protected boolean m_Modified = false;

        public Model() {
            Enumeration<String> enm = NamedSetups.getSingleton().names();
            while (enm.hasMoreElements()) {
                String name = enm.nextElement();
                String cmdline = null;
                try {
                    cmdline = OptionUtils.getCommandLine(NamedSetups.getSingleton().get(name));
                    this.m_Names.add(name);
                    this.m_Setups.put(name, cmdline);
                }
                catch (Exception e) {
                    System.err.println("Failed to obtain command-line for named setup '" + name + "':");
                    e.printStackTrace();
                }
            }
            Collections.sort(this.m_Names);
        }

        @Override
        public int getRowCount() {
            return this.m_Names.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Name";
            }
            if (column == 1) {
                return "Setup";
            }
            throw new IllegalArgumentException("Illegal column: " + column);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.m_Names.get(rowIndex);
            }
            if (columnIndex == 1) {
                return this.m_Setups.get(this.m_Names.get(rowIndex));
            }
            throw new IllegalArgumentException("Illegal column: " + columnIndex);
        }

        public void add(String name, Object obj) {
            this.m_Names.add(name);
            this.m_Setups.put(name, OptionUtils.getCommandLine(obj));
            Collections.sort(this.m_Names);
            this.m_Modified = true;
            this.fireTableDataChanged();
        }

        public void remove(int index) {
            this.remove(this.m_Names.get(index));
        }

        public void remove(String name) {
            this.m_Names.remove(name);
            this.m_Setups.remove(name);
            this.m_Modified = true;
            this.fireTableDataChanged();
        }

        public Properties getProperties() {
            Properties result = new Properties();
            for (int i = 0; i < this.m_Names.size(); ++i) {
                result.setProperty(this.m_Names.get(i), this.m_Setups.get(this.m_Names.get(i)));
            }
            return result;
        }

        public boolean isModified() {
            return this.m_Modified;
        }

        public void setModified(boolean value) {
            this.m_Modified = value;
        }

        public int indexOf(NamedSetup setup) {
            int result = -1;
            for (int i = 0; i < this.m_Names.size(); ++i) {
                if (!this.m_Names.get(i).equals(setup.getName())) continue;
                result = i;
                break;
            }
            return result;
        }
    }
}

