/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.Placeholders;
import adams.core.Properties;
import adams.core.base.BaseString;
import adams.env.Environment;
import adams.gui.chooser.BaseDirectoryChooser;
import adams.gui.core.AbstractBaseTableModel;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseTable;
import adams.gui.core.BaseTableWithButtons;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.MouseUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class PlaceholderManagementPanel
extends BasePanel
implements MenuBarProvider {
    private static final long serialVersionUID = -7798984060662041747L;
    protected PlaceholderTableModel m_Model;
    protected BaseTableWithButtons m_Table;
    protected JMenuBar m_MenuBar;
    protected JMenuItem m_MenuItemSave;
    protected JMenuItem m_MenuItemRevert;
    protected JMenuItem m_MenuItemClose;
    protected JButton m_ButtonAdd;
    protected JButton m_ButtonRemove;
    protected BaseDirectoryChooser m_DirChooser;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_DirChooser = new BaseDirectoryChooser();
        this.m_DirChooser.setDialogTitle("Select directory");
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_Model = new PlaceholderTableModel();
        this.m_Model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                PlaceholderManagementPanel.this.update();
            }
        });
        this.m_Table = new BaseTableWithButtons(this.m_Model);
        this.m_Table.getColumnModel().getColumn(1).setCellEditor(new PlaceholderTableCellEditor((BaseTable)this.m_Table.getComponent(), this.m_Model, this.m_DirChooser));
        this.m_Table.getSelectionModel().setSelectionMode(2);
        this.m_Table.setInfoVisible(true);
        this.m_Table.setAutoResizeMode(0);
        this.m_Table.setOptimalColumnWidth();
        this.m_Table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PlaceholderManagementPanel.this.updateButtons();
            }
        });
        this.m_Table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                PlaceholderManagementPanel.this.m_Table.setOptimalColumnWidth();
            }
        });
        this.add((Component)this.m_Table, "Center");
        this.m_ButtonAdd = new JButton("Add...");
        this.m_ButtonAdd.setMnemonic('A');
        this.m_ButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String key = JOptionPane.showInputDialog(PlaceholderManagementPanel.this, (Object)"Please add new placeholder");
                if (key == null) {
                    return;
                }
                int retVal = PlaceholderManagementPanel.this.m_DirChooser.showOpenDialog(PlaceholderManagementPanel.this);
                if (retVal != 0) {
                    return;
                }
                PlaceholderManagementPanel.this.m_Model.add(key, PlaceholderManagementPanel.this.m_DirChooser.getSelectedFile().getAbsolutePath());
            }
        });
        this.m_Table.addToButtonsPanel(this.m_ButtonAdd);
        this.m_ButtonRemove = new JButton("Remove");
        this.m_ButtonRemove.setMnemonic('R');
        this.m_ButtonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indices = PlaceholderManagementPanel.this.m_Table.getSelectedRows();
                for (int i = indices.length - 1; i >= 0; --i) {
                    PlaceholderManagementPanel.this.m_Model.remove(indices[i]);
                }
            }
        });
        this.m_Table.addToButtonsPanel(this.m_ButtonRemove);
        this.update();
    }

    @Override
    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            if (this.getParentFrame() != null) {
                JFrame frame = (JFrame)this.getParentFrame();
                frame.setDefaultCloseOperation(0);
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        PlaceholderManagementPanel.this.close();
                    }
                });
            } else if (this.getParentDialog() != null) {
                JDialog dialog = (JDialog)this.getParentDialog();
                dialog.setDefaultCloseOperation(0);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        PlaceholderManagementPanel.this.close();
                    }
                });
            }
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PlaceholderManagementPanel.this.updateMenu();
                }
            });
            JMenuItem menuitem = new JMenuItem("Save");
            menu.add(menuitem);
            menuitem.setMnemonic('S');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed S"));
            menuitem.setIcon(GUIHelper.getIcon("save.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlaceholderManagementPanel.this.save();
                }
            });
            this.m_MenuItemSave = menuitem;
            menuitem = new JMenuItem("Revert");
            menu.add(menuitem);
            menuitem.setMnemonic('R');
            menuitem.setIcon(GUIHelper.getIcon("refresh.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlaceholderManagementPanel.this.revert();
                }
            });
            this.m_MenuItemRevert = menuitem;
            menuitem = new JMenuItem("Close");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed Q"));
            menuitem.setIcon(GUIHelper.getIcon("exit.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlaceholderManagementPanel.this.close();
                }
            });
            this.m_MenuItemClose = menuitem;
            this.m_MenuBar = result;
            this.updateMenu();
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    protected void updateTitle() {
        String title = "Placeholder management";
        if (this.m_Model.isModified()) {
            title = "*" + title;
        }
        this.setParentTitle(title);
    }

    protected void updateMenu() {
        this.updateTitle();
        if (this.m_MenuBar == null) {
            return;
        }
        this.m_MenuItemSave.setEnabled(this.m_Model.isModified());
        this.m_MenuItemRevert.setEnabled(this.m_Model.isModified());
        this.m_MenuItemClose.setEnabled(true);
    }

    protected void updateButtons() {
        this.m_ButtonAdd.setEnabled(true);
        this.m_ButtonRemove.setEnabled(this.m_Table.getSelectedRowCount() > 0);
    }

    protected void update() {
        this.updateMenu();
        this.updateTitle();
        this.updateButtons();
    }

    protected boolean checkForModified() {
        boolean result;
        boolean bl = result = !this.m_Model.isModified();
        if (!result) {
            int retVal = GUIHelper.showConfirmMessage(this, "Placeholders are modified - save?", "Placeholders modified");
            switch (retVal) {
                case 0: {
                    this.save();
                    result = !this.m_Model.isModified();
                    break;
                }
                case 1: {
                    result = true;
                    break;
                }
                case 2: {
                    result = false;
                }
            }
        }
        return result;
    }

    protected void save() {
        String filename = Environment.getInstance().getCustomPropertiesFilename("placeholders");
        if (!Environment.getInstance().write("placeholders", this.m_Model.getProperties())) {
            GUIHelper.showErrorMessage(this, "Error saving placeholders to '" + filename + "'!", "Error saving placeholders");
        } else {
            GUIHelper.showInformationMessage(this, "Placeholders have been successfully saved to '" + filename + "'!\n" + "Please restart the application now.", "Placeholders saved");
            this.m_Model.setModified(false);
        }
        this.update();
    }

    protected void revert() {
        this.m_Model = new PlaceholderTableModel();
        this.m_Table.setModel(this.m_Model);
        this.update();
    }

    protected void close() {
        if (!this.checkForModified()) {
            if (this.getParentDialog() != null) {
                this.getParentDialog().setVisible(true);
            } else if (this.getParentFrame() != null) {
                this.getParentFrame().setVisible(true);
            }
            return;
        }
        if (this.getParentFrame() != null) {
            ((JFrame)this.getParentFrame()).setDefaultCloseOperation(2);
        }
        this.closeParent();
    }

    public static class PlaceholderTableCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 8824466216235970313L;
        protected BaseTable m_Table;
        protected PlaceholderTableModel m_TableModel;
        protected JTextField m_TextPath = (JTextField)this.getComponent();
        protected BaseDirectoryChooser m_DirChooser;

        public PlaceholderTableCellEditor(BaseTable table, PlaceholderTableModel model, BaseDirectoryChooser dirChooser) {
            super(new JTextField());
            this.m_TextPath.setToolTipText("Double-click to bring up a dialog to select a directory");
            this.m_TextPath.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (MouseUtils.isDoubleClick(e)) {
                        e.consume();
                        PlaceholderTableCellEditor.this.m_DirChooser.setSelectedFile(new File(PlaceholderTableCellEditor.this.m_TextPath.getText()));
                        int retVal = PlaceholderTableCellEditor.this.m_DirChooser.showOpenDialog(PlaceholderTableCellEditor.this.m_Table);
                        if (retVal != 0) {
                            return;
                        }
                        PlaceholderTableCellEditor.this.m_TextPath.setText(PlaceholderTableCellEditor.this.m_DirChooser.getSelectedFile().getAbsolutePath());
                    } else {
                        super.mouseClicked(e);
                    }
                }
            });
            this.m_Table = table;
            this.m_TableModel = model;
            this.m_DirChooser = dirChooser;
        }
    }

    public static class PlaceholderTableModel
    extends AbstractBaseTableModel {
        private static final long serialVersionUID = -7703129343528534771L;
        protected boolean m_Modified = false;
        protected Hashtable<String, String> m_Values;
        protected Vector<String> m_Keys = new Vector();

        public PlaceholderTableModel() {
            this(Placeholders.getSingleton().toProperties());
        }

        public PlaceholderTableModel(Properties props) {
            this.m_Values = new Hashtable();
            Enumeration<?> enm = props.propertyNames();
            while (enm.hasMoreElements()) {
                String key = (String)enm.nextElement();
                if (key.equals("CWD") || key.equals("PROJECT") || key.equals("TMP") || key.equals("HOME")) continue;
                this.m_Keys.add(key);
                this.m_Values.put(key, props.getProperty(key));
            }
            Collections.sort(this.m_Keys);
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.m_Keys.size();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return String.class;
            }
            if (columnIndex == 1) {
                return String.class;
            }
            throw new IllegalArgumentException("Illegal column: " + columnIndex);
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Key";
            }
            if (column == 1) {
                return "Value";
            }
            throw new IllegalArgumentException("Illegal column: " + column);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.m_Keys.get(rowIndex);
            }
            if (columnIndex == 1) {
                return this.m_Values.get(this.m_Keys.get(rowIndex));
            }
            throw new IllegalArgumentException("Illegal column: " + columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                String newKey = ((String)value).toUpperCase();
                String oldKey = this.m_Keys.get(rowIndex);
                String oldValue = this.m_Values.get(oldKey);
                this.m_Values.remove(oldKey);
                this.m_Keys.set(rowIndex, newKey);
                this.m_Values.put(newKey, oldValue);
                this.m_Modified = true;
                this.fireTableCellUpdated(rowIndex, columnIndex);
            } else if (columnIndex == 1) {
                this.m_Values.put(this.m_Keys.get(rowIndex), (String)value);
                this.m_Modified = true;
                this.fireTableCellUpdated(rowIndex, columnIndex);
            } else {
                throw new IllegalArgumentException("Illegal column: " + columnIndex);
            }
        }

        public void setModified(boolean value) {
            this.m_Modified = value;
        }

        public boolean isModified() {
            return this.m_Modified;
        }

        public void remove(int rowIndex) {
            this.m_Values.remove(this.m_Keys.get(rowIndex));
            this.m_Keys.remove(rowIndex);
            this.m_Modified = true;
            this.fireTableDataChanged();
        }

        public void add(String key, String value) {
            if (this.m_Keys.contains(key = key.toUpperCase())) {
                return;
            }
            this.m_Keys.add(key);
            Collections.sort(this.m_Keys);
            this.m_Values.put(key, value);
            this.m_Modified = true;
            this.fireTableDataChanged();
        }

        public Properties getProperties() {
            Properties result = new Properties();
            Enumeration<String> enm = this.m_Values.keys();
            while (enm.hasMoreElements()) {
                String key = enm.nextElement();
                result.setProperty(key, this.m_Values.get(key));
            }
            return result;
        }

        public BaseString[] getArray() {
            BaseString[] result = new BaseString[this.m_Values.size()];
            Enumeration<String> enm = this.m_Values.keys();
            int i = 0;
            while (enm.hasMoreElements()) {
                String key = enm.nextElement();
                result[i] = new BaseString(key + "=" + this.m_Values.get(key));
                ++i;
            }
            return result;
        }
    }
}

