/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.Properties;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.PropertiesTableModel;
import adams.gui.core.RecentFilesHandler;
import adams.gui.core.SearchPanel;
import adams.gui.core.SortableAndSearchableTable;
import adams.gui.event.RecentItemEvent;
import adams.gui.event.RecentItemListener;
import adams.gui.event.SearchEvent;
import adams.gui.event.SearchListener;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class PropertiesViewerPanel
extends BasePanel
implements MenuBarProvider,
TableModelListener,
SendToActionSupporter {
    private static final long serialVersionUID = -3421194728424946082L;
    public static final String SESSION_FILE = "PropertiesViewerSession.props";
    protected JComboBox m_ComboBoxKeys;
    protected PropertiesTableModel m_TableModel;
    protected SortableAndSearchableTable m_Table;
    protected SearchPanel m_PanelSearch;
    protected JMenuBar m_MenuBar;
    protected JMenuItem m_MenuItemOpen;
    protected JMenu m_MenuLoadRecent;
    protected JMenuItem m_MenuItemSave;
    protected JMenuItem m_MenuItemClose;
    protected File m_CurrentFile;
    protected BaseFileChooser m_FileChooser;
    protected RecentFilesHandler<JMenu> m_RecentFilesHandler;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_CurrentFile = null;
        this.m_FileChooser = new BaseFileChooser();
        ExtensionFileFilter filter = ExtensionFileFilter.getPropertiesFileFilter();
        this.m_FileChooser.addChoosableFileFilter(filter);
        this.m_FileChooser.setFileFilter(filter);
        this.m_FileChooser.setDefaultExtension(filter.getExtensions()[0]);
        this.m_FileChooser.setAutoAppendExtension(true);
        this.m_RecentFilesHandler = null;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        Iterator<String> keys = Environment.getInstance().keys();
        ArrayList<String> list = new ArrayList<String>();
        while (keys.hasNext()) {
            list.add(keys.next());
        }
        Collections.sort(list);
        list.add(0, "");
        this.m_ComboBoxKeys = new JComboBox<String>(list.toArray(new String[list.size()]));
        this.m_ComboBoxKeys.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Properties props;
                if (PropertiesViewerPanel.this.m_ComboBoxKeys.getSelectedIndex() <= 0) {
                    PropertiesViewerPanel.this.open((Properties)null);
                    return;
                }
                PropertiesViewerPanel.this.m_CurrentFile = null;
                try {
                    props = Environment.getInstance().read((String)PropertiesViewerPanel.this.m_ComboBoxKeys.getSelectedItem());
                }
                catch (Exception ex) {
                    System.err.println("Failed to load properties for key '" + PropertiesViewerPanel.this.m_ComboBoxKeys.getSelectedItem() + "':");
                    ex.printStackTrace();
                    props = null;
                }
                PropertiesViewerPanel.this.open(props);
            }
        });
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(new JLabel("Key"));
        panel.add(this.m_ComboBoxKeys);
        this.add((Component)panel, "North");
        this.m_TableModel = new PropertiesTableModel(new Properties());
        this.m_Table = new SortableAndSearchableTable(this.m_TableModel);
        this.m_Table.setAutoResizeMode(0);
        this.add((Component)new BaseScrollPane(this.m_Table), "Center");
        this.m_Table.setOptimalColumnWidth(0);
        panel = new JPanel(new FlowLayout(0));
        this.add((Component)panel, "South");
        this.m_PanelSearch = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true, "_Search", "_Go");
        this.m_PanelSearch.addSearchListener(new SearchListener(){

            @Override
            public void searchInitiated(SearchEvent e) {
                PropertiesViewerPanel.this.m_Table.search(PropertiesViewerPanel.this.m_PanelSearch.getSearchText(), PropertiesViewerPanel.this.m_PanelSearch.isRegularExpression());
                PropertiesViewerPanel.this.m_PanelSearch.grabFocus();
            }
        });
        panel.add(this.m_PanelSearch);
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        this.m_ComboBoxKeys.setSelectedIndex(0);
    }

    @Override
    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            if (this.getParentFrame() != null) {
                JFrame frame = (JFrame)this.getParentFrame();
                frame.setDefaultCloseOperation(0);
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        PropertiesViewerPanel.this.close();
                    }
                });
            } else if (this.getParentDialog() != null) {
                JDialog dialog = (JDialog)this.getParentDialog();
                dialog.setDefaultCloseOperation(0);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        PropertiesViewerPanel.this.close();
                    }
                });
            }
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PropertiesViewerPanel.this.updateMenu();
                }
            });
            JMenuItem menuitem = new JMenuItem("Open...");
            menu.add(menuitem);
            menuitem.setMnemonic('O');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed O"));
            menuitem.setIcon(GUIHelper.getIcon("open.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PropertiesViewerPanel.this.open();
                }
            });
            this.m_MenuItemOpen = menuitem;
            JMenu submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentFilesHandler = new RecentFilesHandler<JMenu>(SESSION_FILE, 5, submenu);
            this.m_RecentFilesHandler.addRecentItemListener(new RecentItemListener<JMenu, File>(){

                @Override
                public void recentItemAdded(RecentItemEvent<JMenu, File> e) {
                }

                @Override
                public void recentItemSelected(RecentItemEvent<JMenu, File> e) {
                    if (!PropertiesViewerPanel.this.checkForModified()) {
                        return;
                    }
                    PropertiesViewerPanel.this.open(e.getItem());
                }
            });
            this.m_MenuLoadRecent = submenu;
            menuitem = new JMenuItem("Save");
            menu.add(menuitem);
            menuitem.setMnemonic('s');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed S"));
            menuitem.setIcon(GUIHelper.getIcon("save.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PropertiesViewerPanel.this.save();
                }
            });
            this.m_MenuItemSave = menuitem;
            menu.addSeparator();
            if (SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, menu)) {
                menu.addSeparator();
            }
            menuitem = new JMenuItem("Close");
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed Q"));
            menuitem.setIcon(GUIHelper.getIcon("exit.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PropertiesViewerPanel.this.close();
                }
            });
            this.m_MenuItemClose = menuitem;
            this.m_MenuBar = result;
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    protected boolean checkForModified() {
        boolean result;
        boolean bl = result = !this.m_TableModel.isModified();
        if (!result) {
            String msg = "Properties not saved - save?\n" + this.m_CurrentFile;
            int retVal = GUIHelper.showConfirmMessage(this, msg, "Properties not saved");
            switch (retVal) {
                case 0: {
                    this.save();
                    result = !this.m_TableModel.isModified();
                    break;
                }
                case 1: {
                    result = true;
                    break;
                }
                case 2: {
                    result = false;
                }
            }
        }
        return result;
    }

    protected void updateMenu() {
        this.m_MenuItemOpen.setEnabled(true);
        this.m_MenuLoadRecent.setEnabled(this.m_RecentFilesHandler.size() > 0);
        this.m_MenuItemSave.setEnabled(this.m_CurrentFile != null && this.m_TableModel.isModified());
        this.m_MenuItemClose.setEnabled(true);
    }

    protected void updateTitle() {
        String title = "Properties viewer";
        if (this.m_CurrentFile != null) {
            title = title + " [" + this.m_CurrentFile + "]";
        }
        if (this.m_TableModel.isModified()) {
            title = "*" + title;
        }
        this.setParentTitle(title);
    }

    protected void close() {
        if (this.getParentFrame() != null) {
            ((JFrame)this.getParentFrame()).setDefaultCloseOperation(2);
        }
        this.closeParent();
    }

    protected void open() {
        int retVal = this.m_FileChooser.showOpenDialog(this);
        if (retVal != 0) {
            return;
        }
        File file = this.m_FileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        this.open(file);
    }

    protected void open(File file) {
        Properties props;
        this.m_ComboBoxKeys.setSelectedIndex(0);
        try {
            props = new Properties();
            props.load(file.getAbsolutePath());
            this.m_CurrentFile = file;
            if (this.m_RecentFilesHandler != null) {
                this.m_RecentFilesHandler.addRecentItem(this.m_CurrentFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            GUIHelper.showErrorMessage(this, "Error loading properties file '" + file + "':\n" + e);
            props = null;
        }
        this.open(props);
    }

    protected void open(Properties props) {
        this.m_TableModel.removeTableModelListener(this);
        if (props != null) {
            this.m_TableModel = new PropertiesTableModel(props);
            this.m_TableModel.addTableModelListener(this);
        } else {
            this.m_TableModel = new PropertiesTableModel();
            this.m_CurrentFile = null;
        }
        this.m_TableModel.setEditable(this.m_CurrentFile != null);
        this.m_Table.setModel(this.m_TableModel);
        this.m_Table.setOptimalColumnWidth();
        this.updateTitle();
    }

    protected void save() {
        Properties props = this.m_TableModel.getProperties();
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.m_CurrentFile.getAbsoluteFile()));
            props.store(writer, "Modified using adams");
            writer.flush();
            writer.close();
            this.m_TableModel.setModified(false);
        }
        catch (Exception e) {
            String msg = "Failed to save properties to '" + this.m_CurrentFile + "':";
            System.err.println(msg);
            e.printStackTrace();
            GUIHelper.showErrorMessage(this, msg + "\n" + e);
        }
        this.updateTitle();
        this.updateMenu();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.updateTitle();
    }

    @Override
    public Class[] getSendToClasses() {
        return new Class[]{PlaceholderFile.class, JTable.class};
    }

    @Override
    public boolean hasSendToItem(Class[] cls) {
        return SendToActionUtils.isAvailable(new Class[]{PlaceholderFile.class, JTable.class}, cls) && this.m_TableModel.getRowCount() > 0;
    }

    @Override
    public Object getSendToItem(Class[] cls) {
        if (this.m_TableModel.getRowCount() == 0) {
            return null;
        }
        Serializable result = null;
        if (SendToActionUtils.isAvailable(PlaceholderFile.class, cls)) {
            Properties props = this.m_TableModel.getProperties();
            if (!props.save(((PlaceholderFile)(result = SendToActionUtils.nextTmpFile("propsviewer", "props"))).getAbsolutePath())) {
                result = null;
            }
        } else if (SendToActionUtils.isAvailable(JTable.class, cls)) {
            result = this.m_Table;
        }
        return result;
    }
}

