/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Utils;
import adams.gui.core.TextEditorPanel;
import adams.gui.core.json.JsonTreeWithPreview;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.PreviewPanel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import net.minidev.json.JSONAware;
import net.minidev.json.parser.JSONParser;

public class JsonHandler
extends AbstractContentHandler {
    private static final long serialVersionUID = -5643331918040646266L;

    @Override
    public String globalInfo() {
        return "Displays JSON files: " + Utils.arrayToString(this.getExtensions());
    }

    @Override
    public String[] getExtensions() {
        return new String[]{"json"};
    }

    @Override
    protected PreviewPanel createPreview(File file) {
        PreviewPanel result;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file.getAbsolutePath()));
            JSONParser parser = new JSONParser(448);
            Object obj = parser.parse((Reader)reader);
            if (obj == null) {
                throw new IllegalStateException("Failed to parse: " + file);
            }
            if (!(obj instanceof JSONAware)) {
                throw new IllegalStateException("Cannot display: " + obj.getClass().getName());
            }
            JsonTreeWithPreview jsonPanel = new JsonTreeWithPreview();
            jsonPanel.setJSON((JSONAware)obj);
            jsonPanel.getTree().expandAll();
            result = new PreviewPanel(jsonPanel);
        }
        catch (Exception e) {
            TextEditorPanel textPanel = new TextEditorPanel();
            textPanel.open(file);
            textPanel.setEditable(false);
            result = new PreviewPanel(textPanel, textPanel.getTextArea());
        }
        return result;
    }
}

