/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core;

import adams.gui.visualization.core.AbstractColorProvider;
import adams.gui.visualization.core.DefaultColorProvider;
import java.awt.Color;

public class TranslucentColorProvider
extends AbstractColorProvider {
    private static final long serialVersionUID = -6184352647827352221L;
    protected int m_Alpha;
    protected AbstractColorProvider m_Provider;

    @Override
    public String globalInfo() {
        return "Allows the user to add translucency to the colors generated by the base color provider.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("alpha", "alpha", 255, 0, 255);
        this.m_OptionManager.add("provider", "provider", new DefaultColorProvider());
    }

    public void setAlpha(int value) {
        if (value >= 0 && value <= 255) {
            this.m_Alpha = value;
            this.reset();
            this.resetColors();
        } else {
            this.getLogger().warning("Alpha must satisfy 0 <= x <= 255, provided: " + value);
        }
    }

    public int getAlpha() {
        return this.m_Alpha;
    }

    public String alphaTipText() {
        return "The alpha value to use (0=translucent, 255=opaque).";
    }

    public void setProvider(AbstractColorProvider value) {
        this.m_Provider = value;
        this.reset();
        this.resetColors();
    }

    public AbstractColorProvider getProvider() {
        return this.m_Provider;
    }

    public String providerTipText() {
        return "The base color provider to use.";
    }

    @Override
    public synchronized void resetColors() {
        if (this.m_Provider != null) {
            this.m_Provider.resetColors();
        }
    }

    @Override
    public synchronized void recycle(Color c) {
        if (this.m_Provider != null) {
            this.m_Provider.recycle(c);
        }
    }

    @Override
    public synchronized void exclude(Color c) {
        if (this.m_Provider != null) {
            this.m_Provider.exclude(c);
        }
    }

    @Override
    public synchronized Color next() {
        if (this.m_Provider == null) {
            return Color.BLACK;
        }
        Color result = this.m_Provider.next();
        if (this.m_Alpha != 255) {
            result = new Color(result.getRed(), result.getGreen(), result.getBlue(), this.m_Alpha);
        }
        return result;
    }
}

