/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core.plot;

import adams.core.CleanUpHandler;
import adams.core.logging.LoggingObject;
import java.awt.event.MouseEvent;
import java.util.logging.Level;

public abstract class AbstractHitDetector
extends LoggingObject
implements CleanUpHandler {
    private static final long serialVersionUID = 7654372428971254128L;
    protected boolean m_Debug = false;
    protected boolean m_Enabled = true;

    public void setDebug(boolean value) {
        this.m_Debug = value;
        this.getLogger().setLevel(value ? Level.INFO : Level.OFF);
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public void setEnabled(boolean value) {
        this.m_Enabled = value;
    }

    public boolean isEnabled() {
        return this.m_Enabled;
    }

    protected abstract Object isHit(MouseEvent var1);

    protected abstract Object processHit(MouseEvent var1, Object var2);

    public Object detect(MouseEvent e) {
        Object result = null;
        Object hit = this.isHit(e);
        this.getLogger().info("Hit (x=" + e.getX() + ",y=" + e.getY() + "): " + (hit != null) + (hit == null ? "" : "/" + hit));
        if (hit != null) {
            result = this.processHit(e, hit);
        }
        return result;
    }

    @Override
    public void cleanUp() {
    }
}

