/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.debug.inspectionhandler;

import adams.core.ClassLister;
import adams.gui.visualization.debug.inspectionhandler.DefaultInspectionHandler;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public abstract class AbstractInspectionHandler {
    protected static Hashtable<Class, List<Class>> m_Cache = new Hashtable();
    protected static String[] m_Handlers = null;
    protected static Class[] m_HandlerClasses = null;

    protected static synchronized void initHandlers() {
        if (m_Handlers != null) {
            return;
        }
        m_Handlers = ClassLister.getSingleton().getClassnames(AbstractInspectionHandler.class);
        m_HandlerClasses = new Class[m_Handlers.length];
        for (int i = 0; i < m_Handlers.length; ++i) {
            try {
                AbstractInspectionHandler.m_HandlerClasses[i] = Class.forName(m_Handlers[i]);
                continue;
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate inspection handler '" + m_Handlers[i] + "': ");
                e.printStackTrace();
            }
        }
    }

    public static synchronized List<AbstractInspectionHandler> getHandler(Object obj) {
        return AbstractInspectionHandler.getHandler(obj.getClass());
    }

    protected static List<AbstractInspectionHandler> instantiate(List<Class> handlers) {
        ArrayList<AbstractInspectionHandler> result = new ArrayList<AbstractInspectionHandler>();
        for (int i = 0; i < handlers.size(); ++i) {
            try {
                result.add((AbstractInspectionHandler)handlers.get(i).newInstance());
                continue;
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate inspection handler '" + handlers.get(i).getName() + "':");
                e.printStackTrace();
            }
        }
        return result;
    }

    public static synchronized List<AbstractInspectionHandler> getHandler(Class cls) {
        AbstractInspectionHandler.initHandlers();
        if (m_Cache.containsKey(cls)) {
            return AbstractInspectionHandler.instantiate(m_Cache.get(cls));
        }
        ArrayList<Class> handlers = new ArrayList<Class>();
        for (int i = 0; i < m_HandlerClasses.length; ++i) {
            if (m_HandlerClasses[i] == DefaultInspectionHandler.class) continue;
            try {
                AbstractInspectionHandler handler = (AbstractInspectionHandler)m_HandlerClasses[i].newInstance();
                if (!handler.handles(cls)) continue;
                handlers.add(m_HandlerClasses[i]);
                break;
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate inspection handler '" + m_HandlerClasses[i].getName() + "':");
                e.printStackTrace();
            }
        }
        if (handlers.size() == 0) {
            handlers.add(DefaultInspectionHandler.class);
        }
        m_Cache.put(cls, handlers);
        return AbstractInspectionHandler.instantiate(handlers);
    }

    public abstract boolean handles(Class var1);

    public abstract Hashtable<String, Object> inspect(Object var1);

    public static String[] getHandlers() {
        return ClassLister.getSingleton().getClassnames(AbstractInspectionHandler.class);
    }
}

