/*
 * Decompiled with CFR 0.152.
 */
package adams.tools;

import adams.core.ClassLister;
import adams.core.CleanUpHandler;
import adams.core.Stoppable;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionUtils;

public abstract class AbstractTool
extends AbstractOptionHandler
implements Comparable,
CleanUpHandler,
Stoppable {
    private static final long serialVersionUID = 8248797808829239144L;
    protected boolean m_Stopped;

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        return OptionUtils.getCommandLine(this).compareTo(OptionUtils.getCommandLine((AbstractTool)o));
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    protected void preRun() {
        this.m_Stopped = false;
    }

    protected abstract void doRun();

    protected void postRun() {
    }

    @Override
    public void stopExecution() {
        this.m_Stopped = true;
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public void destroy() {
        this.cleanUp();
        super.destroy();
    }

    public void run() {
        this.preRun();
        if (!this.m_Stopped) {
            this.doRun();
        }
        if (!this.m_Stopped) {
            this.postRun();
        }
        this.cleanUp();
    }

    public boolean isStopped() {
        return this.m_Stopped;
    }

    public static String[] getTools() {
        return ClassLister.getSingleton().getClassnames(AbstractTool.class);
    }

    public static AbstractTool forName(String classname, String[] options) {
        AbstractTool result;
        try {
            result = (AbstractTool)OptionUtils.forName(AbstractTool.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractTool forCommandLine(String cmdline) {
        return (AbstractTool)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline);
    }
}

