/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Range;
import adams.data.io.input.ODFSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.tools.previewbrowser.AbstractSpreadSheetHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.jopendocument.dom.ODPackage;

public class ODFSpreadSheetHandler
extends AbstractSpreadSheetHandler {
    private static final long serialVersionUID = -57718234789783854L;

    public String[] getExtensions() {
        return new String[]{"ods"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getSheetCount(File file) {
        int result;
        BufferedInputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(file.getAbsoluteFile()));
            org.jopendocument.dom.spreadsheet.SpreadSheet spreadsheet = org.jopendocument.dom.spreadsheet.SpreadSheet.get((ODPackage)new ODPackage((InputStream)input));
            result = spreadsheet.getSheetCount();
        }
        catch (Exception e) {
            result = 0;
            this.getLogger().log(Level.SEVERE, "Failed to determine sheet count for '" + file + "':", e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    protected SpreadSheet[] readAll(File file) {
        List result = new ArrayList();
        ODFSpreadSheetReader reader = new ODFSpreadSheetReader();
        reader.setSheetRange(new Range("first-last"));
        result = reader.readRange(file);
        return result.toArray(new SpreadSheet[result.size()]);
    }
}

