/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.core.attributeclassobservers;

import moa.classifiers.core.AttributeSplitSuggestion;
import moa.classifiers.core.attributeclassobservers.NumericAttributeClassObserver;
import moa.classifiers.core.conditionaltests.NumericAttributeBinaryTest;
import moa.classifiers.core.splitcriteria.SplitCriterion;
import moa.core.AutoExpandVector;
import moa.core.DoubleVector;
import moa.core.GreenwaldKhannaQuantileSummary;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.options.IntOption;
import moa.tasks.TaskMonitor;
import weka.core.Utils;

public class GreenwaldKhannaNumericAttributeClassObserver
extends AbstractOptionHandler
implements NumericAttributeClassObserver {
    private static final long serialVersionUID = 1L;
    protected AutoExpandVector<GreenwaldKhannaQuantileSummary> attValDistPerClass = new AutoExpandVector();
    public IntOption numTuplesOption = new IntOption("numTuples", 'n', "The number of tuples.", 10, 1, Integer.MAX_VALUE);

    @Override
    public void observeAttributeClass(double attVal, int classVal, double weight) {
        if (!Utils.isMissingValue((double)attVal)) {
            GreenwaldKhannaQuantileSummary valDist = this.attValDistPerClass.get(classVal);
            if (valDist == null) {
                valDist = new GreenwaldKhannaQuantileSummary(this.numTuplesOption.getValue());
                this.attValDistPerClass.set(classVal, valDist);
            }
            valDist.insert(attVal);
        }
    }

    @Override
    public double probabilityOfAttributeValueGivenClass(double attVal, int classVal) {
        return 0.0;
    }

    @Override
    public AttributeSplitSuggestion getBestEvaluatedSplitSuggestion(SplitCriterion criterion, double[] preSplitDist, int attIndex, boolean binaryOnly) {
        AttributeSplitSuggestion bestSuggestion = null;
        for (GreenwaldKhannaQuantileSummary qs : this.attValDistPerClass) {
            double[] cutpoints;
            if (qs == null) continue;
            for (double cutpoint : cutpoints = qs.getSuggestedCutpoints()) {
                double[][] postSplitDists = this.getClassDistsResultingFromBinarySplit(cutpoint);
                double merit = criterion.getMeritOfSplit(preSplitDist, postSplitDists);
                if (bestSuggestion != null && !(merit > bestSuggestion.merit)) continue;
                bestSuggestion = new AttributeSplitSuggestion(new NumericAttributeBinaryTest(attIndex, cutpoint, true), postSplitDists, merit);
            }
        }
        return bestSuggestion;
    }

    public double[][] getClassDistsResultingFromBinarySplit(double splitValue) {
        DoubleVector lhsDist = new DoubleVector();
        DoubleVector rhsDist = new DoubleVector();
        for (int i = 0; i < this.attValDistPerClass.size(); ++i) {
            GreenwaldKhannaQuantileSummary estimator = this.attValDistPerClass.get(i);
            if (estimator == null) continue;
            long countBelow = estimator.getCountBelow(splitValue);
            lhsDist.addToValue(i, countBelow);
            rhsDist.addToValue(i, estimator.getTotalCount() - countBelow);
        }
        return new double[][]{lhsDist.getArrayRef(), rhsDist.getArrayRef()};
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }

    @Override
    public void observeAttributeTarget(double attVal, double target) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

