/*
 * Decompiled with CFR 0.152.
 */
package moa.core.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import weka.core.Instance;
import weka.core.Utils;

public abstract class EvalUtils {
    public static final int[] toIntArray(Instance x, int L) {
        int[] y = new int[L];
        for (int j = 0; j < L; ++j) {
            y[j] = (int)Math.round(x.value(j));
        }
        return y;
    }

    public static double calibrateThreshold(ArrayList<double[]> Y, double LC_train) {
        int N = Y.size();
        ArrayList<Double> big = new ArrayList<Double>();
        for (double[] y : Y) {
            for (double y_ : y) {
                big.add(y_);
            }
        }
        Collections.sort(big);
        int i = big.size() - (int)Math.round(LC_train * (double)N);
        return Math.max(((Double)big.get(i) + (Double)big.get(Math.max(i + 1, N - 1))) / 2.0, 1.0E-5);
    }

    public static double[] calibrateThresholds(ArrayList<double[]> Y, double[] LC_train) {
        int L = LC_train.length;
        double[] t = new double[L];
        ArrayList[] Y_ = new ArrayList[Y.size()];
        for (double[] y : Y) {
            for (int j = 0; j < y.length; ++j) {
                Y_[j].add(y);
            }
        }
        for (int j = 0; j < L; ++j) {
            t[j] = EvalUtils.calibrateThreshold(Y_[j], LC_train[j]);
        }
        return t;
    }

    public static HashMap<String, Double> evaluateMultiLabel(ArrayList<double[]> Distributions, ArrayList<int[]> TrueRelevances, double t) {
        double N = Distributions.size();
        int L = Distributions.iterator().next().length;
        int fp = 0;
        int tp = 0;
        int tn = 0;
        int fn = 0;
        int p_sum_total = 0;
        int r_sum_total = 0;
        double log_loss_D = 0.0;
        double log_loss_L = 0.0;
        int set_empty_total = 0;
        int set_inter_total = 0;
        int exact_match = 0;
        int one_error = 0;
        boolean coverage = false;
        double accuracy = 0.0;
        double f1_macro_D = 0.0;
        double f1_macro_L = 0.0;
        int hloss_total = 0;
        int[] o_tp = new int[L];
        int[] o_fp = new int[L];
        int[] o_fn = new int[L];
        int[] o_tn = new int[L];
        int[] d_tp = new int[(int)N];
        int[] d_fp = new int[(int)N];
        int[] d_fn = new int[(int)N];
        int[] d_tn = new int[(int)N];
        int i = 0;
        while ((double)i < N) {
            double[] ranking = Distributions.get(i);
            int[] actual = TrueRelevances.get(i);
            int[] pred = new int[actual.length];
            for (int j = 0; j < L; ++j) {
                pred[j] = ranking[j] >= t ? 1 : 0;
            }
            int p_sum = 0;
            int r_sum = 0;
            int set_union = 0;
            int set_inter = 0;
            boolean doc_inter = false;
            boolean doc_union = false;
            for (int j = 0; j < L; ++j) {
                int p = pred[j];
                int R = actual[j];
                if (p == 1) {
                    ++p_sum;
                    if (R == 1) {
                        ++r_sum;
                        ++tp;
                        int n = j;
                        o_tp[n] = o_tp[n] + 1;
                        int n2 = i;
                        d_tp[n2] = d_tp[n2] + 1;
                        ++set_inter;
                        ++set_union;
                    } else {
                        ++fp;
                        int n = j;
                        o_fp[n] = o_fp[n] + 1;
                        int n3 = i;
                        d_fp[n3] = d_fp[n3] + 1;
                        ++hloss_total;
                        ++set_union;
                    }
                } else if (R == 1) {
                    ++r_sum;
                    ++fn;
                    int n = j;
                    o_fn[n] = o_fn[n] + 1;
                    int n4 = i;
                    d_fn[n4] = d_fn[n4] + 1;
                    ++hloss_total;
                    ++set_union;
                } else {
                    ++tn;
                    int n = j;
                    o_tn[n] = o_tn[n] + 1;
                    int n5 = i;
                    d_tn[n5] = d_tn[n5] + 1;
                }
                log_loss_D += EvalUtils.calcLogLoss(R, ranking[j], Math.log(N));
                log_loss_L += EvalUtils.calcLogLoss(R, ranking[j], Math.log(L));
            }
            set_inter_total += set_inter;
            p_sum_total += p_sum;
            r_sum_total += r_sum;
            if (set_union > 0) {
                accuracy += (double)set_inter / (double)set_union;
            }
            if (p_sum <= 0) {
                ++set_empty_total;
            }
            if (set_inter == set_union) {
                ++exact_match;
            }
            if (p_sum > 0 && r_sum > 0 && set_inter > 0) {
                double prec = (double)set_inter / (double)p_sum;
                double rec = (double)set_inter / (double)r_sum;
                if (prec > 0.0 || rec > 0.0) {
                    f1_macro_D += 2.0 * prec * rec / (prec + rec);
                }
            }
            if (actual[Utils.maxIndex((double[])ranking)] <= 0) {
                ++one_error;
            }
            ++i;
        }
        double[] fms = new double[L];
        for (int j = 0; j < L; ++j) {
            if (o_tp[j] <= 0) {
                fms[j] = 0.0;
                continue;
            }
            double prec = (double)o_tp[j] / ((double)o_tp[j] + (double)o_fp[j]);
            double recall = (double)o_tp[j] / ((double)o_tp[j] + (double)o_fn[j]);
            fms[j] = 2.0 * (prec * recall / (prec + recall));
        }
        double precision = (double)set_inter_total / (double)p_sum_total;
        double recall = (double)set_inter_total / (double)r_sum_total;
        HashMap<String, Double> results = new HashMap<String, Double>();
        results.put("N", N);
        results.put("L", Double.valueOf(L));
        results.put("Accuracy", accuracy / N);
        results.put("F1_micro", 2.0 * precision * recall / (precision + recall));
        results.put("F1_macro_D", f1_macro_D / N);
        results.put("F1_macro_L", Utils.sum((double[])fms) / (double)L);
        results.put("H_loss", (double)hloss_total / (N * (double)L));
        results.put("H_acc", 1.0 - (double)hloss_total / (N * (double)L));
        results.put("LCard_pred", (double)p_sum_total / N);
        results.put("LCard_real", (double)r_sum_total / N);
        results.put("LCard_diff", Math.abs((double)p_sum_total / N - (double)r_sum_total / N));
        results.put("Coverage", (double)coverage / N);
        results.put("One_error", (double)one_error / N);
        results.put("Exact_match", (double)exact_match / N);
        results.put("ZeroOne_loss", 1.0 - (double)exact_match / N);
        results.put("LogLossD", log_loss_D / N);
        results.put("LogLossL", log_loss_L / N);
        results.put("Empty", (double)set_empty_total / N);
        results.put("EmptyAccuracy", accuracy / (N - (double)set_empty_total));
        results.put("EmptyMacroF1", f1_macro_D / (N - (double)set_empty_total));
        results.put("TPR", (double)tp / (double)(tp + fn));
        results.put("FPR", (double)fp / (double)(fp + tn));
        results.put("Precision", precision);
        results.put("Recall", recall);
        results.put("Threshold", t);
        return results;
    }

    public static double calcLogLoss(double R, double P, double C) {
        double ans = Math.min(Utils.eq((double)R, (double)P) ? 0.0 : -(R * Math.log(P) + (1.0 - R) * Math.log(1.0 - P)), C);
        return Double.isNaN(ans) ? 0.0 : ans;
    }
}

