/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import java.util.Arrays;
import java.util.LinkedList;
import moa.AbstractMOAObject;
import moa.classifiers.Classifier;
import moa.clusterers.Clusterer;
import moa.core.Measurement;
import moa.evaluation.ClassificationPerformanceEvaluator;
import moa.evaluation.LearningPerformanceEvaluator;

public class LearningEvaluation
extends AbstractMOAObject {
    private static final long serialVersionUID = 1L;
    protected Measurement[] measurements;

    public LearningEvaluation(Measurement[] measurements) {
        this.measurements = (Measurement[])measurements.clone();
    }

    public LearningEvaluation(Measurement[] evaluationMeasurements, ClassificationPerformanceEvaluator cpe, Classifier model) {
        LinkedList<Measurement> measurementList = new LinkedList<Measurement>();
        measurementList.addAll(Arrays.asList(evaluationMeasurements));
        measurementList.addAll(Arrays.asList(cpe.getPerformanceMeasurements()));
        measurementList.addAll(Arrays.asList(model.getModelMeasurements()));
        this.measurements = measurementList.toArray(new Measurement[measurementList.size()]);
    }

    public LearningEvaluation(Measurement[] evaluationMeasurements, LearningPerformanceEvaluator cpe, Clusterer model) {
        LinkedList<Measurement> measurementList = new LinkedList<Measurement>();
        measurementList.addAll(Arrays.asList(evaluationMeasurements));
        measurementList.addAll(Arrays.asList(cpe.getPerformanceMeasurements()));
        measurementList.addAll(Arrays.asList(model.getModelMeasurements()));
        this.measurements = measurementList.toArray(new Measurement[measurementList.size()]);
    }

    public Measurement[] getMeasurements() {
        return (Measurement[])this.measurements.clone();
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
        Measurement.getMeasurementsDescription(this.measurements, sb, indent);
    }
}

