/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import moa.core.Measurement;
import moa.core.ObjectRepository;
import moa.evaluation.ClassificationPerformanceEvaluator;
import moa.options.AbstractOptionHandler;
import moa.options.IntOption;
import moa.tasks.TaskMonitor;
import weka.core.Instance;
import weka.core.Utils;

public class WindowClassificationPerformanceEvaluator
extends AbstractOptionHandler
implements ClassificationPerformanceEvaluator {
    private static final long serialVersionUID = 1L;
    public IntOption widthOption = new IntOption("width", 'w', "Size of Window", 1000);
    protected double TotalweightObserved = 0.0;
    protected Estimator weightObserved;
    protected Estimator weightCorrect;
    protected Estimator weightCorrectNoChangeClassifier;
    protected double lastSeenClass;
    protected Estimator[] columnKappa;
    protected Estimator[] rowKappa;
    protected Estimator[] classAccuracy;
    protected int numClasses;

    @Override
    public void reset() {
        this.reset(this.numClasses);
    }

    public void reset(int numClasses) {
        this.numClasses = numClasses;
        this.rowKappa = new Estimator[numClasses];
        this.columnKappa = new Estimator[numClasses];
        this.classAccuracy = new Estimator[numClasses];
        for (int i = 0; i < this.numClasses; ++i) {
            this.rowKappa[i] = new Estimator(this.widthOption.getValue());
            this.columnKappa[i] = new Estimator(this.widthOption.getValue());
            this.classAccuracy[i] = new Estimator(this.widthOption.getValue());
        }
        this.weightCorrect = new Estimator(this.widthOption.getValue());
        this.weightCorrectNoChangeClassifier = new Estimator(this.widthOption.getValue());
        this.weightObserved = new Estimator(this.widthOption.getValue());
        this.TotalweightObserved = 0.0;
        this.lastSeenClass = 0.0;
    }

    @Override
    public void addResult(Instance inst, double[] classVotes) {
        double weight = inst.weight();
        int trueClass = (int)inst.classValue();
        if (weight > 0.0) {
            if (this.TotalweightObserved == 0.0) {
                this.reset(inst.dataset().numClasses());
            }
            this.TotalweightObserved += weight;
            this.weightObserved.add(weight);
            int predictedClass = Utils.maxIndex((double[])classVotes);
            if (predictedClass == trueClass) {
                this.weightCorrect.add(weight);
            } else {
                this.weightCorrect.add(0.0);
            }
            for (int i = 0; i < this.numClasses; ++i) {
                this.rowKappa[i].add(i == predictedClass ? weight : 0.0);
                this.columnKappa[i].add(i == trueClass ? weight : 0.0);
            }
            if (this.lastSeenClass == (double)trueClass) {
                this.weightCorrectNoChangeClassifier.add(weight);
            } else {
                this.weightCorrectNoChangeClassifier.add(0.0);
            }
            this.classAccuracy[trueClass].add(predictedClass == trueClass ? weight : 0.0);
            this.lastSeenClass = trueClass;
        }
    }

    @Override
    public Measurement[] getPerformanceMeasurements() {
        return new Measurement[]{new Measurement("classified instances", this.TotalweightObserved), new Measurement("classifications correct (percent)", this.getFractionCorrectlyClassified() * 100.0), new Measurement("Kappa Statistic (percent)", this.getKappaStatistic() * 100.0), new Measurement("Kappa Temporal Statistic (percent)", this.getKappaTemporalStatistic() * 100.0)};
    }

    public double getTotalWeightObserved() {
        return this.weightObserved.total();
    }

    public double getFractionCorrectlyClassified() {
        return this.weightObserved.total() > 0.0 ? this.weightCorrect.total() / this.weightObserved.total() : 0.0;
    }

    public double getKappaStatistic() {
        if (this.weightObserved.total() > 0.0) {
            double p0 = this.weightCorrect.total() / this.weightObserved.total();
            double pc = 0.0;
            for (int i = 0; i < this.numClasses; ++i) {
                pc += this.rowKappa[i].total() / this.weightObserved.total() * (this.columnKappa[i].total() / this.weightObserved.total());
            }
            return (p0 - pc) / (1.0 - pc);
        }
        return 0.0;
    }

    public double getKappaTemporalStatistic() {
        if (this.weightObserved.total() > 0.0) {
            double p0 = this.weightCorrect.total() / this.weightObserved.total();
            double pc = this.weightCorrectNoChangeClassifier.total() / this.weightObserved.total();
            return (p0 - pc) / (1.0 - pc);
        }
        return 0.0;
    }

    public double getFractionIncorrectlyClassified() {
        return 1.0 - this.getFractionCorrectlyClassified();
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
        Measurement.getMeasurementsDescription(this.getPerformanceMeasurements(), sb, indent);
    }

    @Override
    public void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }

    public class Estimator {
        protected double[] window;
        protected int posWindow;
        protected int lenWindow;
        protected int SizeWindow;
        protected double sum;

        public Estimator(int sizeWindow) {
            this.window = new double[sizeWindow];
            this.SizeWindow = sizeWindow;
            this.posWindow = 0;
            this.lenWindow = 0;
        }

        public void add(double value) {
            this.sum -= this.window[this.posWindow];
            this.sum += value;
            this.window[this.posWindow] = value;
            ++this.posWindow;
            if (this.posWindow == this.SizeWindow) {
                this.posWindow = 0;
            }
            if (this.lenWindow < this.SizeWindow) {
                ++this.lenWindow;
            }
        }

        public double total() {
            return this.sum;
        }

        public double length() {
            return this.lenWindow;
        }
    }
}

