/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.visualization;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import moa.evaluation.MeasureCollection;
import moa.gui.visualization.GraphAxes;
import moa.gui.visualization.GraphCurve;
import moa.streams.clustering.ClusterEvent;

public class GraphCanvas
extends JPanel {
    private MeasureCollection measure0 = null;
    private MeasureCollection measure1 = null;
    int measureSelected = 0;
    private ArrayList<ClusterEvent> clusterEvents;
    private ArrayList<JLabel> eventLabelList;
    private GraphAxes axesPanel;
    private GraphCurve curvePanel;
    private JPanel eventPanel;
    private int eventCounter = 0;
    private final int x_offset_left = 35;
    private final int x_offset_right = 5;
    private final int y_offset_bottom = 20;
    private final int y_offset_top = 20;
    private int processFrequency;
    private double min_y_value = 0.0;
    private double max_y_value = 1.0;
    private double max_x_value = 250.0;
    private double x_resolution = 0.5;
    private double y_resolution = 1.0;
    private JViewport viewport;

    public GraphCanvas() {
        this.addComponents();
        this.eventLabelList = new ArrayList();
    }

    public void scaleXResolution(boolean scaleUp) {
        this.x_resolution = scaleUp ? (this.x_resolution *= 2.0) : (this.x_resolution /= 2.0);
        this.updateCanvas(true);
    }

    public void scaleYResolution(boolean scaleUp) {
        this.y_resolution = scaleUp ? (this.y_resolution *= 2.0) : (this.y_resolution /= 2.0);
        this.updateCanvas(true);
    }

    public int getMeasureSelected() {
        return this.measureSelected;
    }

    public int getProcessFrequency() {
        return this.processFrequency;
    }

    public void setGraph(MeasureCollection measure0, MeasureCollection measure1, int mSelect, int processFrequency) {
        this.measure0 = measure0;
        this.measure1 = measure1;
        this.measureSelected = mSelect;
        this.processFrequency = processFrequency;
        this.axesPanel.setProcessFrequency(processFrequency);
        this.curvePanel.setProcessFrequency(processFrequency);
        this.curvePanel.setGraph(measure0, measure1, mSelect);
        this.updateCanvas();
    }

    public void updateCanvas() {
        this.updateCanvas(false);
    }

    public void updateCanvas(boolean force) {
        if (this.updateMinMaxValues() || force) {
            int maxLabel = (int)Math.ceil(this.max_x_value / this.x_resolution / 500.0);
            int width = maxLabel * 500;
            this.setSize(width, this.getHeight());
            this.setPreferredSize(new Dimension(width, this.getHeight()));
            this.axesPanel.setXMaxValue(maxLabel);
            this.updateXResolution();
            this.updateYValues();
            this.updateSize();
            this.axesPanel.repaint();
        }
        this.addEvents();
        this.curvePanel.repaint();
    }

    private boolean updateMinMaxValues() {
        double min_y_value_new = this.min_y_value;
        double max_y_value_new = this.max_y_value;
        double max_x_value_new = this.max_x_value;
        if (this.measure0 != null && this.measure1 != null) {
            min_y_value_new = Math.min(this.measure0.getMinValue(this.measureSelected), this.measure1.getMinValue(this.measureSelected));
            max_y_value_new = Math.max(this.measure0.getMaxValue(this.measureSelected), this.measure1.getMaxValue(this.measureSelected));
            max_x_value_new = Math.max((double)this.measure0.getNumberOfValues(this.measureSelected), this.max_x_value);
        } else if (this.measure0 != null) {
            min_y_value_new = this.measure0.getMinValue(this.measureSelected);
            max_y_value_new = this.measure0.getMaxValue(this.measureSelected);
            max_x_value_new = Math.max((double)this.measure0.getNumberOfValues(this.measureSelected), this.max_x_value);
        }
        if (max_x_value_new != this.max_x_value || max_y_value_new != this.max_y_value || min_y_value_new != this.min_y_value) {
            this.min_y_value = min_y_value_new;
            this.max_y_value = max_y_value_new;
            this.max_x_value = max_x_value_new;
            return true;
        }
        return false;
    }

    private void updateXResolution() {
        this.axesPanel.setXResolution(this.x_resolution);
        this.curvePanel.setXResolution(this.x_resolution);
    }

    private void updateYValues() {
        this.axesPanel.setYMinMaxValues(this.min_y_value, this.max_y_value);
        this.curvePanel.setYMinMaxValues(this.min_y_value, this.max_y_value);
    }

    private void updateSize() {
        this.axesPanel.setSize(this.getWidth(), this.getHeight());
        this.curvePanel.setSize(this.getWidth() - 35 - 5, this.getHeight() - 20 - 20);
        this.eventPanel.setSize(this.getWidth() - 35 - 5, 20);
        if (this.clusterEvents != null) {
            for (int i = 0; i < this.clusterEvents.size(); ++i) {
                int x = (int)((double)(this.clusterEvents.get(i).getTimestamp() / (long)this.processFrequency) / this.x_resolution);
                if (i >= this.eventLabelList.size()) continue;
                this.eventLabelList.get(i).setLocation(x - 10, 0);
            }
        }
    }

    private void addEvents() {
        if (this.clusterEvents != null && this.clusterEvents.size() > this.eventCounter) {
            ClusterEvent ev = this.clusterEvents.get(this.eventCounter);
            ++this.eventCounter;
            JLabel eventMarker = new JLabel(ev.getType().substring(0, 1));
            eventMarker.setPreferredSize(new Dimension(20, 20));
            eventMarker.setSize(new Dimension(20, 20));
            eventMarker.setHorizontalAlignment(0);
            int x = (int)((double)(ev.getTimestamp() / (long)this.processFrequency) / this.x_resolution);
            eventMarker.setLocation(x - 10, 0);
            eventMarker.setToolTipText(ev.getType() + " at " + ev.getTimestamp() + ": " + ev.getMessage());
            this.eventPanel.add(eventMarker);
            this.eventLabelList.add(eventMarker);
            this.eventPanel.repaint();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.updateSize();
        super.paintComponent(g);
    }

    private void addComponents() {
        this.axesPanel = new GraphAxes();
        this.curvePanel = new GraphCurve();
        this.eventPanel = new JPanel();
        this.curvePanel.setLocation(36, 20);
        this.eventPanel.setLocation(36, 0);
        this.eventPanel.setLayout(null);
        this.add(this.axesPanel);
        this.axesPanel.add(this.curvePanel);
        this.axesPanel.add(this.eventPanel);
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
    }

    void setClusterEventsList(ArrayList<ClusterEvent> clusterEvents) {
        this.clusterEvents = clusterEvents;
        this.curvePanel.setClusterEventsList(clusterEvents);
    }

    public void setViewport(JViewport viewport) {
        this.viewport = viewport;
    }
}

