/*
 * Decompiled with CFR 0.152.
 */
package moa.options;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import moa.AbstractMOAObject;
import moa.core.ObjectRepository;
import moa.options.AbstractClassOption;
import moa.options.ClassOption;
import moa.options.ClassOptionWithNames;
import moa.options.Option;
import moa.options.OptionHandler;
import moa.options.Options;
import moa.tasks.NullMonitor;
import moa.tasks.TaskMonitor;

public abstract class AbstractOptionHandler
extends AbstractMOAObject
implements OptionHandler {
    private static final long serialVersionUID = 1L;
    protected Options options;
    protected Map<String, Object> classOptionNamesToPreparedObjects;

    @Override
    public String getPurposeString() {
        return "Anonymous object: purpose undocumented.";
    }

    @Override
    public Options getOptions() {
        if (this.options == null) {
            Option[] myOptions;
            this.options = new Options();
            for (Option option : myOptions = this.discoverOptionsViaReflection()) {
                this.options.addOption(option);
            }
        }
        return this.options;
    }

    @Override
    public void prepareForUse() {
        this.prepareForUse(new NullMonitor(), null);
    }

    @Override
    public void prepareForUse(TaskMonitor monitor, ObjectRepository repository) {
        this.prepareClassOptions(monitor, repository);
        this.prepareForUseImpl(monitor, repository);
    }

    protected abstract void prepareForUseImpl(TaskMonitor var1, ObjectRepository var2);

    @Override
    public String getCLICreationString(Class<?> expectedType) {
        return ClassOption.stripPackagePrefix(this.getClass().getName(), expectedType) + " " + this.getOptions().getAsCLIString();
    }

    @Override
    public OptionHandler copy() {
        return (OptionHandler)super.copy();
    }

    protected Option[] discoverOptionsViaReflection() {
        Class<?> c = this.getClass();
        Field[] fields = c.getFields();
        LinkedList<Option> optList = new LinkedList<Option>();
        for (Field field : fields) {
            String fName = field.getName();
            Class<?> fType = field.getType();
            if (!fName.endsWith("Option") || !Option.class.isAssignableFrom(fType)) continue;
            Option oVal = null;
            try {
                field.setAccessible(true);
                oVal = (Option)field.get(this);
            }
            catch (IllegalAccessException ignored) {
                // empty catch block
            }
            if (oVal == null) continue;
            optList.add(oVal);
        }
        return optList.toArray(new Option[optList.size()]);
    }

    protected void prepareClassOptions(TaskMonitor monitor, ObjectRepository repository) {
        Option[] optionArray;
        this.classOptionNamesToPreparedObjects = null;
        for (Option option : optionArray = this.getOptions().getOptionArray()) {
            Object optionObj;
            AbstractClassOption classOption;
            if (option instanceof ClassOption) {
                classOption = (ClassOption)option;
                monitor.setCurrentActivity("Materializing option " + classOption.getName() + "...", -1.0);
                optionObj = classOption.materializeObject(monitor, repository);
                if (monitor.taskShouldAbort()) {
                    return;
                }
                if (optionObj instanceof OptionHandler) {
                    monitor.setCurrentActivity("Preparing option " + classOption.getName() + "...", -1.0);
                    ((OptionHandler)optionObj).prepareForUse(monitor, repository);
                    if (monitor.taskShouldAbort()) {
                        return;
                    }
                }
                if (this.classOptionNamesToPreparedObjects == null) {
                    this.classOptionNamesToPreparedObjects = new HashMap<String, Object>();
                }
                this.classOptionNamesToPreparedObjects.put(option.getName(), optionObj);
                continue;
            }
            if (!(option instanceof ClassOptionWithNames)) continue;
            classOption = (ClassOptionWithNames)option;
            monitor.setCurrentActivity("Materializing option " + classOption.getName() + "...", -1.0);
            optionObj = classOption.materializeObject(monitor, repository);
            if (monitor.taskShouldAbort()) {
                return;
            }
            if (optionObj instanceof OptionHandler) {
                monitor.setCurrentActivity("Preparing option " + classOption.getName() + "...", -1.0);
                ((OptionHandler)optionObj).prepareForUse(monitor, repository);
                if (monitor.taskShouldAbort()) {
                    return;
                }
            }
            if (this.classOptionNamesToPreparedObjects == null) {
                this.classOptionNamesToPreparedObjects = new HashMap<String, Object>();
            }
            this.classOptionNamesToPreparedObjects.put(option.getName(), optionObj);
        }
    }

    protected Object getPreparedClassOption(ClassOption opt) {
        return this.classOptionNamesToPreparedObjects.get(opt.getName());
    }

    protected Object getPreparedClassOption(ClassOptionWithNames opt) {
        return this.classOptionNamesToPreparedObjects.get(opt.getName());
    }
}

