/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import moa.classifiers.Classifier;
import moa.classifiers.Regressor;
import moa.core.Measurement;
import moa.core.ObjectRepository;
import moa.core.TimingUtils;
import moa.evaluation.EWMAClassificationPerformanceEvaluator;
import moa.evaluation.FadingFactorClassificationPerformanceEvaluator;
import moa.evaluation.LearningCurve;
import moa.evaluation.LearningEvaluation;
import moa.evaluation.RegressionPerformanceEvaluator;
import moa.evaluation.WindowClassificationPerformanceEvaluator;
import moa.options.ClassOption;
import moa.options.FileOption;
import moa.options.FloatOption;
import moa.options.IntOption;
import moa.streams.InstanceStream;
import moa.tasks.RegressionMainTask;
import moa.tasks.TaskMonitor;
import weka.core.Instance;
import weka.core.Utils;

public class EvaluatePrequentialRegression
extends RegressionMainTask {
    private static final long serialVersionUID = 1L;
    public ClassOption learnerOption = new ClassOption("learner", 'l', "Classifier to train.", Regressor.class, "trees.FIMTDD");
    public ClassOption streamOption = new ClassOption("stream", 's', "Stream to learn from.", InstanceStream.class, "generators.RandomTreeGenerator");
    public ClassOption evaluatorOption = new ClassOption("evaluator", 'e', "Classification performance evaluation method.", RegressionPerformanceEvaluator.class, "WindowRegressionPerformanceEvaluator");
    public IntOption instanceLimitOption = new IntOption("instanceLimit", 'i', "Maximum number of instances to test/train on  (-1 = no limit).", 100000000, -1, Integer.MAX_VALUE);
    public IntOption timeLimitOption = new IntOption("timeLimit", 't', "Maximum number of seconds to test/train for (-1 = no limit).", -1, -1, Integer.MAX_VALUE);
    public IntOption sampleFrequencyOption = new IntOption("sampleFrequency", 'f', "How many instances between samples of the learning performance.", 100000, 0, Integer.MAX_VALUE);
    public IntOption memCheckFrequencyOption = new IntOption("memCheckFrequency", 'q', "How many instances between memory bound checks.", 100000, 0, Integer.MAX_VALUE);
    public FileOption dumpFileOption = new FileOption("dumpFile", 'd', "File to append intermediate csv results to.", null, "csv", true);
    public FileOption outputPredictionFileOption = new FileOption("outputPredictionFile", 'o', "File to append output predictions to.", null, "pred", true);
    public IntOption widthOption = new IntOption("width", 'w', "Size of Window", 1000);
    public FloatOption alphaOption = new FloatOption("alpha", 'a', "Fading factor or exponential smoothing factor", 0.01);

    @Override
    public String getPurposeString() {
        return "Evaluates a classifier on a stream by testing then training with each example in sequence.";
    }

    @Override
    public Class<?> getTaskResultType() {
        return LearningCurve.class;
    }

    @Override
    protected Object doMainTask(TaskMonitor monitor, ObjectRepository repository) {
        long evaluateStartTime;
        Classifier learner = (Classifier)this.getPreparedClassOption(this.learnerOption);
        InstanceStream stream = (InstanceStream)this.getPreparedClassOption(this.streamOption);
        RegressionPerformanceEvaluator evaluator = (RegressionPerformanceEvaluator)this.getPreparedClassOption(this.evaluatorOption);
        LearningCurve learningCurve = new LearningCurve("learning evaluation instances");
        if (evaluator instanceof WindowClassificationPerformanceEvaluator && this.widthOption.getValue() != 1000) {
            System.out.println("DEPRECATED! Use EvaluatePrequential -e (WindowClassificationPerformanceEvaluator -w " + this.widthOption.getValue() + ")");
            return learningCurve;
        }
        if (evaluator instanceof EWMAClassificationPerformanceEvaluator && this.alphaOption.getValue() != 0.01) {
            System.out.println("DEPRECATED! Use EvaluatePrequential -e (EWMAClassificationPerformanceEvaluator -a " + this.alphaOption.getValue() + ")");
            return learningCurve;
        }
        if (evaluator instanceof FadingFactorClassificationPerformanceEvaluator && this.alphaOption.getValue() != 0.01) {
            System.out.println("DEPRECATED! Use EvaluatePrequential -e (FadingFactorClassificationPerformanceEvaluator -a " + this.alphaOption.getValue() + ")");
            return learningCurve;
        }
        learner.setModelContext(stream.getHeader());
        int maxInstances = this.instanceLimitOption.getValue();
        long instancesProcessed = 0L;
        int maxSeconds = this.timeLimitOption.getValue();
        int secondsElapsed = 0;
        monitor.setCurrentActivity("Evaluating learner...", -1.0);
        File dumpFile = this.dumpFileOption.getFile();
        PrintStream immediateResultStream = null;
        if (dumpFile != null) {
            try {
                immediateResultStream = dumpFile.exists() ? new PrintStream(new FileOutputStream(dumpFile, true), true) : new PrintStream(new FileOutputStream(dumpFile), true);
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to open immediate result file: " + dumpFile, ex);
            }
        }
        File outputPredictionFile = this.outputPredictionFileOption.getFile();
        PrintStream outputPredictionResultStream = null;
        if (outputPredictionFile != null) {
            try {
                outputPredictionResultStream = outputPredictionFile.exists() ? new PrintStream(new FileOutputStream(outputPredictionFile, true), true) : new PrintStream(new FileOutputStream(outputPredictionFile), true);
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to open prediction result file: " + outputPredictionFile, ex);
            }
        }
        boolean firstDump = true;
        boolean preciseCPUTiming = TimingUtils.enablePreciseTiming();
        long lastEvaluateStartTime = evaluateStartTime = TimingUtils.getNanoCPUTimeOfCurrentThread();
        double RAMHours = 0.0;
        while (!(!stream.hasMoreInstances() || maxInstances >= 0 && instancesProcessed >= (long)maxInstances || maxSeconds >= 0 && secondsElapsed >= maxSeconds)) {
            Instance trainInst = stream.nextInstance();
            Instance testInst = (Instance)trainInst.copy();
            int trueClass = (int)trainInst.classValue();
            double[] prediction = learner.getVotesForInstance(testInst);
            if (outputPredictionFile != null) {
                outputPredictionResultStream.println(Utils.maxIndex((double[])prediction) + "," + trueClass);
            }
            evaluator.addResult(testInst, prediction);
            learner.trainOnInstance(trainInst);
            if (++instancesProcessed % (long)this.sampleFrequencyOption.getValue() == 0L || !stream.hasMoreInstances()) {
                long evaluateTime = TimingUtils.getNanoCPUTimeOfCurrentThread();
                double time = TimingUtils.nanoTimeToSeconds(evaluateTime - evaluateStartTime);
                double timeIncrement = TimingUtils.nanoTimeToSeconds(evaluateTime - lastEvaluateStartTime);
                double RAMHoursIncrement = (double)learner.measureByteSize() / 1.073741824E9;
                lastEvaluateStartTime = evaluateTime;
                learningCurve.insertEntry(new LearningEvaluation(new Measurement[]{new Measurement("learning evaluation instances", instancesProcessed), new Measurement("evaluation time (" + (preciseCPUTiming ? "cpu " : "") + "seconds)", time), new Measurement("model cost (RAM-Hours)", RAMHours += (RAMHoursIncrement *= timeIncrement / 3600.0))}, evaluator, learner));
                if (immediateResultStream != null) {
                    if (firstDump) {
                        immediateResultStream.println(learningCurve.headerToString());
                        firstDump = false;
                    }
                    immediateResultStream.println(learningCurve.entryToString(learningCurve.numEntries() - 1));
                    immediateResultStream.flush();
                }
            }
            if (instancesProcessed % 10L != 0L) continue;
            if (monitor.taskShouldAbort()) {
                return null;
            }
            long estimatedRemainingInstances = stream.estimatedRemainingInstances();
            if (maxInstances > 0) {
                long maxRemaining = (long)maxInstances - instancesProcessed;
                if (estimatedRemainingInstances < 0L || maxRemaining < estimatedRemainingInstances) {
                    estimatedRemainingInstances = maxRemaining;
                }
            }
            monitor.setCurrentActivityFractionComplete(estimatedRemainingInstances < 0L ? -1.0 : (double)instancesProcessed / (double)(instancesProcessed + estimatedRemainingInstances));
            if (monitor.resultPreviewRequested()) {
                monitor.setLatestResultPreview(learningCurve.copy());
            }
            secondsElapsed = (int)TimingUtils.nanoTimeToSeconds(TimingUtils.getNanoCPUTimeOfCurrentThread() - evaluateStartTime);
        }
        if (immediateResultStream != null) {
            immediateResultStream.close();
        }
        if (outputPredictionResultStream != null) {
            outputPredictionResultStream.close();
        }
        return learningCurve;
    }
}

