/*
 * Decompiled with CFR 0.152.
 */
package adams.data.twitter;

import adams.core.DateFormat;
import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.DateFormatString;
import adams.data.twitter.AbstractTwitterStatusConverter;
import adams.data.twitter.TwitterField;
import java.util.Date;
import java.util.Hashtable;

public class TextConverter
extends AbstractTwitterStatusConverter<String> {
    private static final long serialVersionUID = 1409389451601382272L;
    protected String m_Separator;
    protected boolean m_Quote;
    protected DateFormatString m_DateFormat;

    public String globalInfo() {
        return "A simple text converter.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("separator", "separator", (Object)"\t");
        this.m_OptionManager.add("quote", "quote", (Object)false);
        this.m_OptionManager.add("date-format", "dateFormat", (Object)new DateFormatString("yyyy-MM-dd HH:mm:ss"));
    }

    public void setSeparator(String value) {
        this.m_Separator = Utils.unbackQuoteChars((String)value);
        this.reset();
    }

    public String getSeparator() {
        return Utils.backQuoteChars((String)this.m_Separator);
    }

    public String separatorTipText() {
        return "The separator to use when generating strings as output; tab, new line, carriage return and backslash need to be escaped, ie, '\t', '\n', '\r', '\\'.";
    }

    public void setQuote(boolean value) {
        this.m_Quote = value;
        this.reset();
    }

    public boolean getQuote() {
        return this.m_Quote;
    }

    public String quoteTipText() {
        return "If enabled all sub-strings are quoted if necessary when generating string output.";
    }

    public void setDateFormat(DateFormatString value) {
        this.m_DateFormat = value;
        this.reset();
    }

    public DateFormatString getDateFormat() {
        return this.m_DateFormat;
    }

    public String dateFormatTipText() {
        return "The format for the dates.";
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"separator", (Object)Utils.backQuoteChars((String)this.m_Separator), (String)", separator: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"quote", (boolean)this.m_Quote, (String)"quote", (String)", ");
        return result;
    }

    @Override
    public Class generates() {
        return String.class;
    }

    @Override
    protected String doConvert(Hashtable<TwitterField, Object> fields) {
        StringBuilder result = new StringBuilder();
        DateFormat dformat = this.m_DateFormat.toDateFormat();
        for (int i = 0; i < this.m_Fields.length; ++i) {
            Object obj;
            if (i > 0) {
                result.append(this.m_Separator);
            }
            if ((obj = fields.get((Object)this.m_Fields[i])) == null) {
                result.append("?");
                continue;
            }
            String str = obj instanceof Date ? dformat.format((Date)obj) : "" + obj;
            if (this.m_Quote) {
                result.append(Utils.doubleQuote((String)str));
                continue;
            }
            result.append(str);
        }
        return result.toString();
    }
}

