/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.Variables;
import adams.core.logging.AbstractLogHandler;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingLevel;
import adams.core.logging.LoggingListener;
import adams.core.option.OptionHandler;
import adams.flow.control.Sequence;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.Compatibility;
import adams.flow.core.DaemonEvent;
import adams.flow.core.InputConsumer;
import adams.flow.core.MutableActorHandler;
import adams.flow.core.Token;
import adams.flow.standalone.AbstractStandalone;
import adams.flow.standalone.logevent.AbstractLogRecordFilter;
import adams.flow.standalone.logevent.AbstractLogRecordProcessor;
import adams.flow.standalone.logevent.AcceptAllFilter;
import adams.flow.standalone.logevent.SimpleProcessor;
import com.jidesoft.utils.SwingWorker;
import java.util.logging.LogRecord;

public class LogEvent
extends AbstractStandalone
implements MutableActorHandler,
DaemonEvent,
LoggingListener {
    private static final long serialVersionUID = 4670761846363281951L;
    public static final String BUSY = "BUSY";
    public static final String NO_OUTPUT = "No output produced";
    protected AbstractLogRecordFilter m_Filter;
    protected AbstractLogRecordProcessor m_Processor;
    protected boolean m_NoDiscard;
    protected Sequence m_Actors;
    protected boolean m_ExecutingActors;

    public String globalInfo() {
        return "Listens to the global log record handler and processes records that passed the specified filter(s).\nThis allows, for instance, the output of log messages into a log file.\nBy default, log records are only processed if the sub-actors are not currently being executed. In other words, log records will get dropped if the record processing takes longer than the record generation. Enable the 'noDiscard' property to process all log events - NB: this can slow down the system significantly.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filter", "filter", (Object)new AcceptAllFilter());
        this.m_OptionManager.add("processor", "processor", (Object)new SimpleProcessor());
        this.m_OptionManager.add("no-discard", "noDiscard", (Object)false);
        this.m_OptionManager.add("actor", "actors", (Object)new AbstractActor[0]);
    }

    protected void initialize() {
        super.initialize();
        this.m_Actors = new Sequence();
        this.m_Actors.setAllowSource(false);
        this.m_Actors.setAllowStandalones(false);
    }

    public void setLoggingLevel(LoggingLevel value) {
        super.setLoggingLevel(value);
        this.m_Actors.setLoggingLevel(value);
    }

    protected String checkActors(AbstractActor[] actors) {
        Compatibility comp = new Compatibility();
        for (int i = 0; i < actors.length; ++i) {
            if (actors[i].getSkip()) continue;
            if (!(actors[i] instanceof InputConsumer)) {
                return "Actor #" + (i + 1) + " does not accept input!";
            }
            if (comp.isCompatible(new Class[]{this.m_Processor.generates()}, ((InputConsumer)actors[i]).accepts())) break;
            return "Actor #" + (i + 1) + " does not accept the processor's output: " + Utils.classToString((Class)this.m_Processor.generates());
        }
        return null;
    }

    protected void updateParent() {
        this.m_Actors.setParent(null);
        this.m_Actors.setParent((AbstractActor)this);
    }

    public void setFilter(AbstractLogRecordFilter value) {
        this.m_Filter = value;
        this.reset();
    }

    public AbstractLogRecordFilter getFilter() {
        return this.m_Filter;
    }

    public String filterTipText() {
        return "The filter used for selecting log records for processing.";
    }

    public void setProcessor(AbstractLogRecordProcessor value) {
        this.m_Processor = value;
        this.reset();
    }

    public AbstractLogRecordProcessor getProcessor() {
        return this.m_Processor;
    }

    public String processorTipText() {
        return "The processor used for turning the log record into a different format.";
    }

    public void setNoDiscard(boolean value) {
        this.m_NoDiscard = value;
        this.reset();
    }

    public boolean getNoDiscard() {
        return this.m_NoDiscard;
    }

    public String noDiscardTipText() {
        return "If enabled, no log event gets discarded; CAUTION: enabling this option can slow down the system significantly.";
    }

    public void setActors(AbstractActor[] value) {
        String msg = this.checkActors(value);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        this.m_Actors.setActors(value);
        this.reset();
        this.updateParent();
    }

    public AbstractActor[] getActors() {
        return this.m_Actors.getActors();
    }

    public String actorsTipText() {
        return "The actors to process the output generated from the log record.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"filter", (Object)((Object)this.m_Filter), (String)"filter: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"processor", (Object)((Object)this.m_Processor), (String)", processor: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"noDiscard", (boolean)this.m_NoDiscard, (String)"no discard", (String)", ");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String processRecord(LogRecord record) {
        if (!this.m_Filter.acceptRecord(record)) {
            return null;
        }
        final Object processed = this.m_Processor.processRecord(record);
        if (processed == null) {
            return NO_OUTPUT;
        }
        if (this.m_ExecutingActors) {
            if (!this.m_NoDiscard) {
                return BUSY;
            }
            while (this.m_ExecutingActors && !this.m_Stopped) {
                try {
                    LogEvent logEvent = this;
                    synchronized (logEvent) {
                        ((Object)((Object)this)).wait(10L);
                    }
                }
                catch (Exception e) {
                }
            }
        }
        if (this.m_Stopped) {
            return null;
        }
        this.m_ExecutingActors = true;
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                LogEvent.this.m_Actors.input(new Token(processed));
                String result = LogEvent.this.m_Actors.execute();
                return result;
            }

            protected void done() {
                super.done();
                LogEvent.this.m_ExecutingActors = false;
            }
        };
        worker.execute();
        return null;
    }

    public int size() {
        return this.m_Actors.size();
    }

    public AbstractActor get(int index) {
        return this.m_Actors.get(index);
    }

    public void set(int index, AbstractActor actor) {
        this.m_Actors.set(index, actor);
        this.reset();
        this.updateParent();
    }

    public int indexOf(String actor) {
        return this.m_Actors.indexOf(actor);
    }

    public void add(AbstractActor actor) {
        this.add(this.size(), actor);
    }

    public void add(int index, AbstractActor actor) {
        this.m_Actors.add(index, actor);
        this.reset();
        this.updateParent();
    }

    public AbstractActor remove(int index) {
        AbstractActor result = this.m_Actors.remove(index);
        this.reset();
        return result;
    }

    public void removeAll() {
        this.m_Actors.removeAll();
        this.reset();
    }

    public void setHeadless(boolean value) {
        super.setHeadless(value);
        this.m_Actors.setHeadless(value);
    }

    public ActorHandlerInfo getActorHandlerInfo() {
        return this.m_Actors.getActorHandlerInfo();
    }

    public int active() {
        return this.m_Actors.active();
    }

    public AbstractActor firstActive() {
        return this.m_Actors.firstActive();
    }

    public AbstractActor lastActive() {
        return this.m_Actors.lastActive();
    }

    public String check() {
        String result = this.m_Actors.check();
        if (result == null) {
            result = this.checkActors(this.m_Actors.getActors());
        }
        return result;
    }

    protected void forceVariables(Variables value) {
        super.forceVariables(value);
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).setVariables(value);
        }
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null && (result = this.m_Actors.setUp()) == null) {
            if (!(LoggingHelper.getDefaultHandler() instanceof AbstractLogHandler)) {
                result = "Default logging handler (" + LoggingHelper.getDefaultHandler().getClass().getName() + ") " + "is not derived from " + AbstractLogHandler.class.getName() + "!";
            } else {
                ((AbstractLogHandler)LoggingHelper.getDefaultHandler()).addLoggingListener((LoggingListener)this);
            }
        }
        return result;
    }

    public void logEventOccurred(AbstractLogHandler source, LogRecord record) {
        if (!this.m_Stopped) {
            this.processRecord(record);
        }
    }

    protected String doExecute() {
        return null;
    }

    public void stopExecution() {
        this.m_Actors.stopExecution();
        super.stopExecution();
    }

    public void wrapUp() {
        if (this.m_Actors != null) {
            this.m_Actors.wrapUp();
        }
        if (LoggingHelper.getDefaultHandler() instanceof AbstractLogHandler) {
            ((AbstractLogHandler)LoggingHelper.getDefaultHandler()).removeLoggingListener((LoggingListener)this);
        }
        super.wrapUp();
    }

    public void cleanUp() {
        if (this.m_Actors != null) {
            this.m_Actors.cleanUp();
        }
        super.cleanUp();
    }
}

