/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.VariableNameNoUpdate;
import adams.core.Variables;
import adams.core.logging.LoggingLevel;
import adams.core.option.OptionHandler;
import adams.event.VariableChangeEvent;
import adams.flow.control.Sequence;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.ActorUtils;
import adams.flow.core.DaemonEvent;
import adams.flow.core.MutableActorHandler;
import adams.flow.standalone.AbstractStandalone;
import com.jidesoft.utils.SwingWorker;

public class VariableChangedEvent
extends AbstractStandalone
implements MutableActorHandler,
DaemonEvent {
    private static final long serialVersionUID = 4670761846363281951L;
    public static final String BUSY = "BUSY";
    protected VariableNameNoUpdate m_Variable;
    protected boolean m_NoDiscard;
    protected Sequence m_Actors;
    protected boolean m_ExecutingActors;

    public String globalInfo() {
        return "Listens to a any changes to the specified variable.\nThis allows, for instance, the monitoring of a variable.\nEnable the 'noDiscard' property to process all change events - NB: this can slow down the system significantly.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("variable", "variable", (Object)new VariableNameNoUpdate());
        this.m_OptionManager.add("no-discard", "noDiscard", (Object)false);
        this.m_OptionManager.add("actor", "actors", (Object)new AbstractActor[0]);
    }

    protected void initialize() {
        super.initialize();
        this.m_Actors = new Sequence();
        this.m_Actors.setAllowSource(true);
        this.m_Actors.setAllowStandalones(true);
    }

    public void setLoggingLevel(LoggingLevel value) {
        super.setLoggingLevel(value);
        this.m_Actors.setLoggingLevel(value);
    }

    protected String checkActors(AbstractActor[] actors) {
        for (int i = 0; i < actors.length; ++i) {
            if (actors[i].getSkip() || ActorUtils.isStandalone((AbstractActor)actors[i])) continue;
            if (ActorUtils.isSource((AbstractActor)actors[i])) break;
            return "Actor #" + (i + 1) + " does not produce any output!";
        }
        return null;
    }

    protected void updateParent() {
        this.m_Actors.setParent(null);
        this.m_Actors.setParent((AbstractActor)this);
    }

    public void setVariable(VariableNameNoUpdate value) {
        this.m_Variable = value;
        this.reset();
    }

    public VariableNameNoUpdate getVariable() {
        return this.m_Variable;
    }

    public String variableTipText() {
        return "The variable to monitor for changes.";
    }

    public void setNoDiscard(boolean value) {
        this.m_NoDiscard = value;
        this.reset();
    }

    public boolean getNoDiscard() {
        return this.m_NoDiscard;
    }

    public String noDiscardTipText() {
        return "If enabled, no change event gets discarded; CAUTION: enabling this option can slow down the system significantly.";
    }

    public void setActors(AbstractActor[] value) {
        String msg = this.checkActors(value);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        this.m_Actors.setActors(value);
        this.reset();
        this.updateParent();
    }

    public AbstractActor[] getActors() {
        return this.m_Actors.getActors();
    }

    public String actorsTipText() {
        return "The actors to execute in case of a change event.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"variable", (Object)this.m_Variable, (String)"var: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"noDiscard", (boolean)this.m_NoDiscard, (String)"no discard", (String)", ");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String processChangeEvent(VariableChangeEvent e) {
        if (this.m_ExecutingActors) {
            if (!this.m_NoDiscard) {
                return BUSY;
            }
            while (this.m_ExecutingActors && !this.m_Stopped) {
                try {
                    VariableChangedEvent variableChangedEvent = this;
                    synchronized (variableChangedEvent) {
                        ((Object)((Object)this)).wait(10L);
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        if (this.m_Stopped) {
            return null;
        }
        this.m_ExecutingActors = true;
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                String result = VariableChangedEvent.this.m_Actors.execute();
                return result;
            }

            protected void done() {
                super.done();
                VariableChangedEvent.this.m_ExecutingActors = false;
            }
        };
        worker.execute();
        return null;
    }

    public int size() {
        return this.m_Actors.size();
    }

    public AbstractActor get(int index) {
        return this.m_Actors.get(index);
    }

    public void set(int index, AbstractActor actor) {
        this.m_Actors.set(index, actor);
        this.reset();
        this.updateParent();
    }

    public int indexOf(String actor) {
        return this.m_Actors.indexOf(actor);
    }

    public void add(AbstractActor actor) {
        this.add(this.size(), actor);
    }

    public void add(int index, AbstractActor actor) {
        this.m_Actors.add(index, actor);
        this.reset();
        this.updateParent();
    }

    public AbstractActor remove(int index) {
        AbstractActor result = this.m_Actors.remove(index);
        this.reset();
        return result;
    }

    public void removeAll() {
        this.m_Actors.removeAll();
        this.reset();
    }

    public void setHeadless(boolean value) {
        super.setHeadless(value);
        this.m_Actors.setHeadless(value);
    }

    public ActorHandlerInfo getActorHandlerInfo() {
        return this.m_Actors.getActorHandlerInfo();
    }

    public int active() {
        return this.m_Actors.active();
    }

    public AbstractActor firstActive() {
        return this.m_Actors.firstActive();
    }

    public AbstractActor lastActive() {
        return this.m_Actors.lastActive();
    }

    public String check() {
        String result = this.m_Actors.check();
        if (result == null) {
            result = this.checkActors(this.m_Actors.getActors());
        }
        return result;
    }

    protected void forceVariables(Variables value) {
        super.forceVariables(value);
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).setVariables(value);
        }
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            result = this.m_Actors.setUp();
        }
        return result;
    }

    public void variableChanged(VariableChangeEvent e) {
        if (e.getName().equals(this.m_Variable.getValue())) {
            this.processChangeEvent(e);
        }
    }

    protected String doExecute() {
        return null;
    }

    public void stopExecution() {
        this.m_Actors.stopExecution();
        super.stopExecution();
    }

    public void wrapUp() {
        if (this.m_Actors != null) {
            this.m_Actors.wrapUp();
        }
        super.wrapUp();
    }

    public void cleanUp() {
        if (this.m_Actors != null) {
            this.m_Actors.cleanUp();
        }
        super.cleanUp();
    }
}

