/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net;

import adams.core.Properties;
import adams.core.net.EmailAddress;
import adams.core.net.EmailContact;
import adams.core.option.OptionUtils;
import adams.env.Environment;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class EmailAddressBook {
    public static final String FILENAME = "EmailAddressBook.props";
    protected static EmailAddressBook m_Singleton;
    protected Properties m_Properties;

    public synchronized Properties getProperties() {
        if (this.m_Properties == null) {
            this.m_Properties = new Properties();
            this.m_Properties.load(Environment.getInstance().createPropertiesFilename(FILENAME));
        }
        return this.m_Properties;
    }

    public synchronized boolean save() {
        return this.getProperties().save(Environment.getInstance().createPropertiesFilename(FILENAME));
    }

    public Object addContact(EmailContact value) {
        return this.getProperties().setProperty(EmailAddressBook.createKey(value), EmailAddressBook.toString(value));
    }

    public EmailContact getContact(EmailAddress address) {
        return this.getContact(address, null);
    }

    public EmailContact getContact(EmailAddress address, EmailContact defValue) {
        return EmailAddressBook.fromString(this.getProperties().getProperty(address.stringValue(), EmailAddressBook.toString(defValue)));
    }

    public List<EmailContact> getContacts() {
        ArrayList<EmailContact> result = new ArrayList<EmailContact>();
        Enumeration enm = this.getProperties().propertyNames();
        while (enm.hasMoreElements()) {
            String key = enm.nextElement().toString();
            EmailContact value = EmailAddressBook.fromString(this.getProperties().getProperty(key));
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    public static EmailContact fromString(String s) {
        try {
            s = EmailContact.class.getName() + " " + s;
            return (EmailContact)OptionUtils.forCommandLine(EmailContact.class, (String)s);
        }
        catch (Exception e) {
            System.err.println("Failed to parse: " + s);
            e.printStackTrace();
            return null;
        }
    }

    public static String createKey(EmailContact value) {
        return value.getEmail();
    }

    public static String toString(EmailContact value) {
        if (value == null) {
            return "";
        }
        String result = value.toCommandLine();
        result = result.replace(EmailContact.class.getName(), "");
        return result;
    }

    public static synchronized EmailAddressBook getSingleton() {
        if (m_Singleton == null) {
            m_Singleton = new EmailAddressBook();
        }
        return m_Singleton;
    }
}

