/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseURL;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import gnu.trove.list.array.TByteArrayList;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;

public class HttpPost
extends AbstractTransformer {
    private static final long serialVersionUID = 4296378541399733662L;
    protected BaseURL m_URL;

    public String globalInfo() {
        return "Allows to send string content via HTTP POST. Simply outputs the content of the response as string.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("url", "URL", (Object)new BaseURL("http://localhost/"));
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"url", (Object)this.m_URL, (String)"URL: ");
    }

    public void setURL(BaseURL value) {
        this.m_URL = value;
        this.reset();
    }

    public BaseURL getURL() {
        return this.m_URL;
    }

    public String URLTipText() {
        return "The URL to post the string content to.";
    }

    public Class[] accepts() {
        return new Class[]{String.class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doExecute() {
        String result = null;
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            org.apache.http.client.methods.HttpPost httppost = new org.apache.http.client.methods.HttpPost(this.m_URL.toString());
            httppost.setEntity((HttpEntity)new StringEntity((String)this.m_InputToken.getPayload()));
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            HttpEntity entity = response.getEntity();
            TByteArrayList content = new TByteArrayList();
            if (entity != null) {
                try (InputStream instream = entity.getContent();){
                    int read;
                    while ((read = instream.read()) > -1) {
                        content.add((byte)read);
                    }
                }
            }
            this.m_OutputToken = new Token((Object)new String(content.toArray()));
        }
        catch (Exception e) {
            result = this.handleException("Failed to post data!", e);
        }
        return result;
    }
}

