/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.DateTime;
import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.DataRowType;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;

public class TimeseriesToSpreadSheet
extends AbstractConversion {
    private static final long serialVersionUID = -7385757807406641857L;
    protected DataRowType m_DataRowType;
    protected SpreadSheet m_SpreadSheetType;

    public String globalInfo() {
        return "Turns a timeseries into a SpreadSheet object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("data-row-type", "dataRowType", (Object)DataRowType.DENSE);
        this.m_OptionManager.add("spreadsheet-type", "spreadSheetType", (Object)new SpreadSheet());
    }

    public void setDataRowType(DataRowType value) {
        this.m_DataRowType = value;
        this.reset();
    }

    public DataRowType getDataRowType() {
        return this.m_DataRowType;
    }

    public String dataRowTypeTipText() {
        return "The type of row to use for the data.";
    }

    public void setSpreadSheetType(SpreadSheet value) {
        this.m_SpreadSheetType = value;
        this.reset();
    }

    public SpreadSheet getSpreadSheetType() {
        return this.m_SpreadSheetType;
    }

    public String spreadSheetTypeTipText() {
        return "The type of spreadsheet to use for the data.";
    }

    public Class accepts() {
        return Timeseries.class;
    }

    public Class generates() {
        if (this.m_SpreadSheetType != null) {
            return this.m_SpreadSheetType.getClass();
        }
        return SpreadSheet.class;
    }

    protected Object doConvert() throws Exception {
        Timeseries series = (Timeseries)((Object)this.m_Input);
        SpreadSheet result = this.m_SpreadSheetType.newInstance();
        result.setDataRowClass(this.m_DataRowType.getRowClass());
        result.setName(series.getID());
        HeaderRow row = result.getHeaderRow();
        row.addCell("T").setContent("Timestamp");
        row.addCell("V").setContent("Value");
        for (Object obj : series.toList()) {
            TimeseriesPoint point = (TimeseriesPoint)((Object)obj);
            row = result.addRow();
            row.addCell("T").setContent(new DateTime(point.getTimestamp()));
            row.addCell("V").setContent(Double.valueOf(point.getValue()));
        }
        return result;
    }
}

