/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.core.base.BaseDateTime;
import adams.data.container.DataPoint;
import adams.data.filter.AbstractFilter;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import java.util.Date;

public class SetStart
extends AbstractFilter<Timeseries> {
    private static final long serialVersionUID = 2616498525816421178L;
    protected BaseDateTime m_Start;

    public String globalInfo() {
        return "Sets the starting point of the timeseries to a new fixed timestamp and all other data points accordingly.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("start", "start", (Object)new BaseDateTime("NOW"));
    }

    public void setStart(BaseDateTime value) {
        this.m_Start = value;
        this.reset();
    }

    public BaseDateTime getStart() {
        return this.m_Start;
    }

    public String startTipText() {
        return "The new timestamp for the first data point in series.";
    }

    protected Timeseries processData(Timeseries data) {
        Timeseries result = data.getHeader();
        long diff = 0L;
        for (int i = 0; i < data.size(); ++i) {
            TimeseriesPoint point = (TimeseriesPoint)((Object)data.toList().get(i));
            if (i == 0) {
                diff = point.getTimestamp().getTime() - this.m_Start.dateValue().getTime();
            }
            TimeseriesPoint pointNew = new TimeseriesPoint(new Date(point.getTimestamp().getTime() - diff), point.getValue());
            result.add((DataPoint)pointNew);
        }
        return result;
    }
}

