/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.SequencePlotterContainer;
import adams.flow.container.WekaForecastContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.ArrayList;
import java.util.List;
import weka.classifiers.evaluation.NumericPrediction;

public class MakeForecastPlotContainer
extends AbstractTransformer {
    private static final long serialVersionUID = 2488434486963278287L;
    protected String m_PlotNames;
    protected List<SequencePlotterContainer> m_Queue;

    public String globalInfo() {
        return "Creates a named containers for the SequencePlotter actor using the incoming forecasts.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("plot-names", "plotNames", (Object)"");
    }

    protected void initialize() {
        super.initialize();
        this.m_Queue = new ArrayList<SequencePlotterContainer>();
    }

    protected void reset() {
        super.reset();
        this.m_Queue.clear();
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"plotNames", (Object)(this.m_PlotNames.length() > 0 ? this.m_PlotNames : "-unnamed-"));
    }

    public void setPlotNames(String value) {
        this.m_PlotNames = value;
        this.reset();
    }

    public String getPlotNames() {
        return this.m_PlotNames;
    }

    public String plotNamesTipText() {
        return "The names for the plots (comma-separated list).";
    }

    public Class[] accepts() {
        return new Class[]{WekaForecastContainer.class};
    }

    protected String doExecute() {
        String result = null;
        WekaForecastContainer forecast = (WekaForecastContainer)((Object)this.m_InputToken.getPayload());
        List list = (List)forecast.getValue("Forecasts");
        String[] names = this.m_PlotNames.length() == 0 ? null : this.m_PlotNames.split(",");
        for (List preds : list) {
            int i;
            if (names == null) {
                names = new String[preds.size()];
                for (i = 0; i < names.length; ++i) {
                    names[i] = "Forecast-" + (i + 1);
                }
            }
            for (i = 0; i < names.length && i < preds.size(); ++i) {
                SequencePlotterContainer cont = new SequencePlotterContainer(names[i], (Comparable)Double.valueOf(((NumericPrediction)preds.get(i)).predicted()));
                this.m_Queue.add(cont);
            }
        }
        return result;
    }

    public Class[] generates() {
        return new Class[]{SequencePlotterContainer.class};
    }

    public boolean hasPendingOutput() {
        return this.m_Queue != null && this.m_Queue.size() > 0;
    }

    public Token output() {
        Token result = new Token((Object)this.m_Queue.get(0));
        this.m_Queue.remove(0);
        return result;
    }
}

