/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.timeseries.eval;

import java.util.List;
import weka.classifiers.evaluation.NumericPrediction;
import weka.classifiers.timeseries.eval.ErrorModule;
import weka.core.Utils;

public class MAEModule
extends ErrorModule {
    @Override
    public String getEvalName() {
        return "MAE";
    }

    @Override
    public String getDescription() {
        return "Mean absolute error";
    }

    @Override
    public String getDefinition() {
        return "sum(abs(predicted - actual)) / N";
    }

    @Override
    public double[] calculateMeasure() throws Exception {
        int i;
        double[] result = new double[this.m_targetFieldNames.size()];
        for (i = 0; i < result.length; ++i) {
            result[i] = Utils.missingValue();
        }
        for (i = 0; i < this.m_targetFieldNames.size(); ++i) {
            double sumAbs = 0.0;
            List preds = (List)this.m_predictions.get(i);
            int count = 0;
            for (NumericPrediction p : preds) {
                if (Utils.isMissingValue((double)p.error())) continue;
                sumAbs += Math.abs(p.error());
                ++count;
            }
            if (this.m_counts[i] > 0.0) {
                sumAbs /= this.m_counts[i];
            }
            result[i] = count > 0 ? sumAbs : Utils.missingValue();
        }
        return result;
    }
}

