/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.timeseries.eval;

import weka.classifiers.timeseries.eval.MSEModule;
import weka.core.Utils;

public class RMSEModule
extends MSEModule {
    @Override
    public String getEvalName() {
        return "RMSE";
    }

    @Override
    public String getDescription() {
        return "Root mean squared error";
    }

    @Override
    public String getDefinition() {
        return "sqrt(sum((predicted - actual)^2) / N)";
    }

    @Override
    public double[] calculateMeasure() throws Exception {
        double[] result = super.calculateMeasure();
        for (int i = 0; i < result.length; ++i) {
            if (Utils.isMissingValue((double)result[i])) continue;
            result[i] = Math.sqrt(result[i]);
        }
        return result;
    }
}

