/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.timeseries.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import weka.classifiers.timeseries.gui.ForecastingPanel;
import weka.core.Instances;
import weka.gui.LogPanel;
import weka.gui.Logger;
import weka.gui.WekaTaskMonitor;
import weka.gui.explorer.Explorer;

public class ExplorerTSPanel
extends JPanel
implements Explorer.ExplorerPanel,
Explorer.LogHandler {
    private static final long serialVersionUID = -7313227058091543628L;
    protected Logger m_log;
    protected ForecastingPanel m_forecastingPanel;

    public ExplorerTSPanel() {
        this.setLayout(new BorderLayout());
        this.m_forecastingPanel = new ForecastingPanel(null, false, false, false);
        this.add((Component)this.m_forecastingPanel, "Center");
    }

    public void setExplorer(Explorer parent) {
    }

    public Explorer getExplorer() {
        return null;
    }

    public void setInstances(Instances inst) {
        if (this.m_forecastingPanel != null) {
            try {
                this.m_forecastingPanel.setInstances(inst);
            }
            catch (Exception ex) {
                if (this.m_log != null) {
                    this.m_log.logMessage(ex.getMessage());
                }
                ex.printStackTrace();
            }
        }
    }

    public String getTabTitle() {
        return "Forecast";
    }

    public String getTabTitleToolTip() {
        return "Build and evaluate time series forecasting models";
    }

    public void setLog(Logger newLog) {
        if (newLog instanceof JComponent && this.m_forecastingPanel != null) {
            this.m_log = newLog;
            this.m_forecastingPanel.setLog(newLog);
        }
    }

    public static void main(String[] args) {
        try {
            Instances insts = new Instances((Reader)new BufferedReader(new FileReader(args[0])));
            ExplorerTSPanel pan = new ExplorerTSPanel();
            pan.setInstances(insts);
            pan.setLog((Logger)new LogPanel(new WekaTaskMonitor()));
            final JFrame frame = new JFrame("Forecasting");
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    frame.dispose();
                    System.exit(1);
                }
            });
            frame.setSize(800, 600);
            frame.setContentPane(pan);
            frame.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

