/*
 * Decompiled with CFR 0.152.
 */
package org.postgis;

import java.io.Serializable;
import org.postgis.Point;

public abstract class Geometry
implements Serializable {
    private static final long serialVersionUID = 256L;
    public static final int LINEARRING = 0;
    public static final int POINT = 1;
    public static final int LINESTRING = 2;
    public static final int POLYGON = 3;
    public static final int MULTIPOINT = 4;
    public static final int MULTILINESTRING = 5;
    public static final int MULTIPOLYGON = 6;
    public static final int GEOMETRYCOLLECTION = 7;
    public static final String[] ALLTYPES = new String[]{"", "POINT", "LINESTRING", "POLYGON", "MULTIPOINT", "MULTILINESTRING", "MULTIPOLYGON", "GEOMETRYCOLLECTION"};
    public int dimension;
    public boolean haveMeasure = false;
    public final int type;
    public int srid = -1;

    public static String getTypeString(int n) {
        if (n >= 0 && n <= 7) {
            return ALLTYPES[n];
        }
        throw new IllegalArgumentException("Unknown Geometry type" + n);
    }

    protected Geometry(int n) {
        this.type = n;
    }

    public int hashCode() {
        return this.dimension | this.type * 4 | this.srid * 32;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Geometry && this.equals((Geometry)object);
    }

    public boolean equals(Geometry geometry) {
        return geometry != null && this.dimension == geometry.dimension && this.type == geometry.type && this.srid == geometry.srid && this.haveMeasure == geometry.haveMeasure && geometry.getClass().equals(this.getClass()) && this.equalsintern(geometry);
    }

    protected abstract boolean equalsintern(Geometry var1);

    public abstract int numPoints();

    public abstract Point getPoint(int var1);

    public abstract Point getFirstPoint();

    public abstract Point getLastPoint();

    public int getType() {
        return this.type;
    }

    public String getTypeString() {
        return Geometry.getTypeString(this.type);
    }

    public boolean isMeasured() {
        return this.haveMeasure;
    }

    public int getDimension() {
        return this.dimension;
    }

    public int getSrid() {
        return this.srid;
    }

    public void setSrid(int n) {
        this.srid = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.srid != -1) {
            stringBuffer.append("SRID=");
            stringBuffer.append(this.srid);
            stringBuffer.append(';');
        }
        this.outerWKT(stringBuffer, true);
        return stringBuffer.toString();
    }

    public void outerWKT(StringBuffer stringBuffer, boolean bl) {
        stringBuffer.append(this.getTypeString());
        if (bl && this.haveMeasure && this.dimension == 2) {
            stringBuffer.append('M');
        }
        this.mediumWKT(stringBuffer);
    }

    public final void outerWKT(StringBuffer stringBuffer) {
        this.outerWKT(stringBuffer, true);
    }

    protected void mediumWKT(StringBuffer stringBuffer) {
        stringBuffer.append('(');
        this.innerWKT(stringBuffer);
        stringBuffer.append(')');
    }

    protected abstract void innerWKT(StringBuffer var1);

    public String getValue() {
        StringBuffer stringBuffer = new StringBuffer();
        this.mediumWKT(stringBuffer);
        return stringBuffer.toString();
    }

    public boolean checkConsistency() {
        return this.dimension >= 2 && this.dimension <= 3 && this.type >= 0 && this.type <= 7;
    }

    protected String initSRID(String string) {
        if ((string = string.trim()).startsWith("SRID=")) {
            int n = string.indexOf(59, 5);
            if (n == -1) {
                throw new IllegalArgumentException("Error parsing Geometry - SRID not delimited with ';' ");
            }
            this.srid = Integer.parseInt(string.substring(5, n));
            return string.substring(n + 1).trim();
        }
        return string;
    }
}

