/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractConversion;
import adams.data.conversion.mapobject.AbstractReportMapObjectGenerator;
import adams.data.conversion.mapobject.SimpleReportCircleMarkerGenerator;
import adams.data.report.Report;
import org.openstreetmap.gui.jmapviewer.interfaces.MapObject;

public class ReportToMapObject
extends AbstractConversion {
    private static final long serialVersionUID = -5361157360265877867L;
    protected AbstractReportMapObjectGenerator m_Generator;

    public String globalInfo() {
        return "Creates features from the incoming reports and turns them into a OpenStreetMap MapObject.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "generator", (Object)new SimpleReportCircleMarkerGenerator());
    }

    public void setGenerator(AbstractReportMapObjectGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public AbstractReportMapObjectGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The generator to use for turning the report into a MapObject.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"generator", (Object)((Object)this.m_Generator));
    }

    public Class accepts() {
        return Report.class;
    }

    public Class generates() {
        if (this.m_Generator == null) {
            return MapObject.class;
        }
        return this.m_Generator.generates();
    }

    protected Object doConvert() throws Exception {
        Report report = (Report)this.m_Input;
        Object result = this.m_Generator.generate(report);
        return result;
    }
}

