/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion.mapobject;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.mapobject.AbstractMapObjectGenerator;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import org.openstreetmap.gui.jmapviewer.interfaces.MapRectangle;

public abstract class AbstractMapRectangleGenerator
extends AbstractMapObjectGenerator<MapRectangle> {
    private static final long serialVersionUID = -8754565176631384914L;
    protected SpreadSheetColumnIndex m_TopLeft;
    protected int m_TopLeftIndex;
    protected SpreadSheetColumnIndex m_BottomRight;
    protected int m_BottomRightIndex;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("top-left", "topLeft", (Object)new SpreadSheetColumnIndex());
        this.m_OptionManager.add("bottom-right", "bottomRight", (Object)new SpreadSheetColumnIndex());
    }

    public void setTopLeft(SpreadSheetColumnIndex value) {
        this.m_TopLeft = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getTopLeft() {
        return this.m_TopLeft;
    }

    public String topLeftTipText() {
        return "The index of the column containing the GPS objects of the top-left corner.";
    }

    public void setBottomRight(SpreadSheetColumnIndex value) {
        this.m_BottomRight = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getBottomRight() {
        return this.m_BottomRight;
    }

    public String bottomRightTipText() {
        return "The index of the column containing the GPS objects of the bottom-right corner.";
    }

    @Override
    public Class generates() {
        return MapRectangle[].class;
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"topLeft", (Object)this.m_TopLeft, (String)", top-left: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"bottomRight", (Object)this.m_BottomRight, (String)", bottom-right: ");
        return result;
    }

    @Override
    protected void check(SpreadSheet sheet) {
        super.check(sheet);
        this.m_TopLeft.setData((Object)sheet);
        if (this.m_TopLeft.getIntIndex() == -1) {
            throw new IllegalStateException("Failed to locate top-left column: " + this.m_TopLeft.getIndex());
        }
        this.m_BottomRight.setData((Object)sheet);
        if (this.m_BottomRight.getIntIndex() == -1) {
            throw new IllegalStateException("Failed to locate bottom-right column: " + this.m_BottomRight.getIndex());
        }
    }

    @Override
    protected void init(SpreadSheet sheet) {
        super.init(sheet);
        this.m_TopLeftIndex = this.m_TopLeft.getIntIndex();
        this.m_BottomRightIndex = this.m_BottomRight.getIntIndex();
    }
}

