/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.openstreetmapviewer;

import adams.core.VariableName;
import adams.flow.control.StorageName;
import adams.flow.sink.OpenStreetMapViewer;
import adams.flow.sink.openstreetmapviewer.AbstractPositionableMapOverlayWithDimensions;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

public class TextMapOverlay
extends AbstractPositionableMapOverlayWithDimensions {
    private static final long serialVersionUID = 805661569976845842L;
    protected int m_OffsetX;
    protected int m_OffsetY;
    protected String m_Text;
    protected VariableName m_VariableName;
    protected StorageName m_StorageName;
    protected Color m_TextColor;
    protected Font m_Font;

    public String globalInfo() {
        return "Displays text, either fixed, from a variable or from storage.\nPrecedence: fixed > variable > storage";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("offset-x", "offsetX", (Object)4);
        this.m_OptionManager.add("offset-y", "offsetY", (Object)-4);
        this.m_OptionManager.add("text", "text", (Object)"");
        this.m_OptionManager.add("storage-name", "storageName", (Object)new StorageName(""));
        this.m_OptionManager.add("variable-name", "variableName", (Object)new VariableName());
        this.m_OptionManager.add("text-color", "textColor", (Object)Color.BLACK);
        this.m_OptionManager.add("font", "font", (Object)new Font("helvetica", 0, 12));
    }

    @Override
    protected int getDefaultHeight() {
        return 20;
    }

    @Override
    public String heightTipText() {
        return "The height of the bounding box around the text.";
    }

    @Override
    protected int getDefaultWidth() {
        return 100;
    }

    @Override
    public String widthTipText() {
        return "The width of the bounding box around the text.";
    }

    public void setOffsetX(int value) {
        this.m_OffsetX = value;
        this.reset();
    }

    public int getOffsetX() {
        return this.m_OffsetX;
    }

    public String offsetXTipText() {
        return "The X offset for the text.";
    }

    public void setOffsetY(int value) {
        this.m_OffsetY = value;
        this.reset();
    }

    public int getOffsetY() {
        return this.m_OffsetY;
    }

    public String offsetYTipText() {
        return "The Y offset for the text.";
    }

    public void setText(String value) {
        this.m_Text = value;
        this.reset();
    }

    public String getText() {
        return this.m_Text;
    }

    public String textTipText() {
        return "The fixed text to output.";
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the storage item to output.";
    }

    public void setVariableName(VariableName value) {
        this.m_VariableName = value;
        this.reset();
    }

    public VariableName getVariableName() {
        return this.m_VariableName;
    }

    public String variableNameTipText() {
        return "The variable to use for the filename instead of the auto-generated one.";
    }

    public void setTextColor(Color value) {
        this.m_TextColor = value;
        this.reset();
    }

    public Color getTextColor() {
        return this.m_TextColor;
    }

    public String textColorTipText() {
        return "The text color.";
    }

    public void setFont(Font value) {
        this.m_Font = value;
        this.reset();
    }

    public Font getFont() {
        return this.m_Font;
    }

    public String fontTipText() {
        return "The font to use for the text.";
    }

    @Override
    protected void doPaintOverlay(OpenStreetMapViewer viewer, Graphics g, int x, int y) {
        String str = "";
        if (this.m_Text.length() > 0) {
            str = this.m_Text;
        } else if (viewer.getVariables().has(this.m_VariableName.getValue())) {
            str = viewer.getVariables().get(this.m_VariableName.getValue());
        } else if (viewer.getStorageHandler().getStorage().has(this.m_StorageName)) {
            str = viewer.getStorageHandler().getStorage().get(this.m_StorageName).toString();
        }
        g.setColor(this.m_TextColor);
        g.setFont(this.m_Font);
        g.drawString(str, x + this.m_OffsetX, y + this.m_OffsetY);
    }
}

